#!/bin/bash

OS_SUBDIR=linux64
BIN=lola
VERSION=2.0.b

echo `uname`

if [ `uname` = "Darwin" ]; then
  if [ `uname -m` = "arm64" ]; then
    OS_SUBDIR=macarm
  else
    OS_SUBDIR=macintel
  fi
fi

if [[ `uname` == CYGWIN* ]]; then
    echo "On Cygwin/Windows use .exe as binary."
    OS_SUBDIR=win64
    BIN=lola.exe
    VERSION=2.0.b-cygwin
fi

# build lola (full) in version 2.0
LOLADIR=lola-${VERSION}
echo Directory is ${LOLADIR}

# download lola version 2.0 if it doesn't exist
if [ -e lola-${VERSION} ]; then
    echo "Lola 2.0 source directory exists, continuing..."
else
    curl -O https://git.informatik.uni-hamburg.de/tgipublic/lola/lola/-/archive/${VERSION}/lola-${VERSION}.tar.gz
    tar zxf lola-${VERSION}.tar.gz
    rm lola-${VERSION}.tar.gz
fi

cd ${LOLADIR}
./configure
make clean
make
cp src/${BIN} ../lib/${OS_SUBDIR}/${BIN}
cp COPYING ../lib/${OS_SUBDIR}/lola-LICENSE.txt
