package de.renew.lola2.analysis;

/**
 * This class represents the result of a LoLA analysis that is not directly
 * obtained from the LoLA tool, but rather encapsulates the status of the
 * analysis.
 * It implements the LolaResult interface.
 */
public class IndirectLolaResult implements LolaResult {
    private LolaResultStatus _status;

    /**
     * Constructs an IndirectLolaResult with the given status.
     *
     * @param status The status of the LoLA analysis result.
     */
    public IndirectLolaResult(LolaResultStatus status) {
        this._status = status;
    }

    @Override
    public LolaResultStatus getStatus() {
        return this._status;
    }
}