package de.renew.lola2.analysis;

import java.io.File;

import de.renew.plugin.PluginProperties;


/**
 * Defines constants used in the context of lola.
 * @author hewelt
 *
 */
public class LolaHelper {
    private static org.apache.log4j.Logger _logger =
        org.apache.log4j.Logger.getLogger(LolaHelper.class);

    /**
     * The command to call LoLA.
     * This is the name of the executable that runs LoLA.
     */
    public static final String LOLA_COMMAND = "lola";

    /**
     * Finds and returns the temporary directory to be used by LoLA.
     * First attempts to use the directory specified in the user property "de.renew.lola.tmpdir".
     * If not found, falls back to the system property "java.io.tmpdir".
     * If neither property is available, logs an error and returns null.
     *
     * @return The temporary directory as a File object, or null if no temporary directory could be determined.
     */
    public static File findTmpDir() {
        String tmp = PluginProperties.getUserProperties().getProperty("de.renew.lola.tmpdir");
        File dir;
        if (tmp != null) {
            dir = new File(tmp);
        } else {
            tmp = System.getProperty("java.io.tmpdir");
            if (tmp != null) {
                dir = new File(tmp);
            } else {
                _logger.error(
                    "System property java.io.tmpdir not found, please provide de.renew.lola.tmpdir in your user properties");
                return null;
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("[Lola] tmpDir successfully set");
        }
        return dir;
    }
}