package de.renew.lola2.parser;

/**
 * Represents a marking in a Lola2 Petri net.
 */
public class Marking {
    private String _name;
    private int _tokens;

    /**
     * Default constructor for a marking with the tokens.
     *
     * @param name the name of the marking
     * @param tokens the number of tokens in the marking
     */
    public Marking(String name, int tokens) {
        this._name = name;
        this._tokens = tokens;
    }

    /**
     * @return the name
     */
    public String getName() {
        return _name;
    }

    /**
     * @param name the name to set
     */
    protected void setName(String name) {
        this._name = name;
    }

    /**
     * @return the tokens
     */
    public int getTokens() {
        return _tokens;
    }

    /**
     * @param tokens the tokens to set
     */
    protected void setTokens(int tokens) {
        this._tokens = tokens;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Marking) {
            return getName().equals(((Marking) o).getName())
                && getTokens() == ((Marking) o).getTokens();
        } else {
            return false;
        }
    }
}