package de.renew.lola2.parser;

/**
 * Represents a node in a Lola2 Petri net.
 * A node has coordinates (x, y) and a name.
 */
public class Node {
    private Integer _x = null;
    private Integer _y = null;
    private String _name;

    /**
     * Default constructor for a node with coordinates and a name.
     *
     * @param name the name of the node
     * @param x the x-coordinate of the node
     * @param y the y-coordinate of the node
     */
    protected Node(String name, int x, int y) {
        this._x = x;
        this._y = y;
        this._name = name;
    }

    /**
     * Default constructor for a node with a name only.
     *
     * @param name the name of the node
     */
    protected Node(String name) {
        this._name = name;
    }

    /**
     * Returns the x-coordinate of the node.
     *
     * @return the x-coordinate of the node, or null if not set
     */
    public Integer getX() {
        return _x;
    }

    /**
     * Sets the x-coordinate of the node.
     *
     * @param x the x-coordinate to set
     */
    protected void setX(Integer x) {
        this._x = x;
    }

    /**
     * Returns the y-coordinate of the node.
     *
     * @return the y-coordinate of the node, or null if not set
     */
    public Integer getY() {
        return _y;
    }

    /**
     * Sets the y-coordinate of the node.
     *
     * @param y the y-coordinate to set
     */
    protected void setY(Integer y) {
        this._y = y;
    }

    /**
     * Returns the name of the node.
     *
     * @return the name of the node
     */
    public String getName() {
        return _name;
    }

    /**
     * Returns true if the node has coordinates (x, y) set.
     *
     * @return true if the node has coordinates, false otherwise
     */
    public boolean hasCoordinates() {
        return (getX() != null) && (getY() != null);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Node) {
            return getName().equals(((Node) o).getName());
        } else {
            return false;
        }
    }
}