package de.renew.lola2.parser;

/**
 * Represents a place in a Lola2 Petri net.
 */
public class Place extends Node {
    private int _initialMarking = 0;

    /**
     * Default constructor for a place with a name.
     *
     * @param name the name of the place
     */
    public Place(String name) {
        super(name);
    }

    /**
     * Default constructor for a place with a name and coordinates.
     *
     * @param name the name of the place
     * @param x the x-coordinate of the place
     * @param y the y-coordinate of the place
     */
    public Place(String name, int x, int y) {
        super(name, x, y);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Place) {
            return getName().equals(((Place) o).getName());
        } else {
            return false;
        }
    }

    /**
     * Returns whether this place is initially marked.
     *
     * @return true if the place is initially marked, false otherwise
     */
    public boolean initiallyMarked() {
        return _initialMarking > 0;
    }

    /**
     * Sets the initial marking of this place.
     *
     * @param initialMarking the initialMarking to set
     */
    protected void setInitialMarking(int initialMarking) {
        this._initialMarking = initialMarking;
    }

    /**
     * Returns the initial marking of this place.
     *
     * @return the initial marking of the place
     */
    public int getInitialMarking() {
        return _initialMarking;
    }
}