package de.renew.call;

import de.renew.engine.searcher.EarlyExecutable;
import de.renew.simulatorontology.simulation.StepIdentifier;
import de.renew.unify.Impossible;

/**
 * The {@code BlockExecutable} class implements the {@link EarlyExecutable} interface and represents
 * an execution step that blocks a particular synchronization request. It ensures proper locking
 * and synchronization mechanisms during execution phases.
 */
class BlockExecutable implements EarlyExecutable {

    SynchronisationRequest _synchronisation;

    /**
     * Constructs a {@link BlockExecutable} object.
     * @param synchronisation the {@link SynchronisationRequest} object.
     */
    BlockExecutable(SynchronisationRequest synchronisation) {
        this._synchronisation = synchronisation;
    }

    @Override
    public int phase() {
        return BLOCK;
    }

    @Override
    public long lockPriority() {
        return _synchronisation._lockOrder;
    }

    /**
     * Locks the {@link SynchronisationRequest#_lock} associated with this arc.
     **/
    @Override
    public void lock() {
        _synchronisation._lock.lock();
    }

    @Override
    public void verify(StepIdentifier stepIdentifier) throws Impossible {
        if (_synchronisation._completed) {
            throw new Impossible();
        }
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        _synchronisation._completed = true;
    }

    @Override
    public void rollback() {
        // Nothing to do.
    }

    /**
     * Unlocks the {@link SynchronisationRequest#_lock} associated with this arc.
     **/
    @Override
    public void unlock() {
        _synchronisation._lock.unlock();
    }
}
