package de.renew.call;

import de.renew.net.NetInstance;

/**
 * NetInstance-subclass calling {@link OwnedNetInstance} which carries a reference to some Java object called owner.
 * Such objects can implement the NetOwner interface so that others can retrieve their owned {@link NetInstance}.
 */
public interface NetOwner {

    /**
     * Retrieves the associated {@link NetInstance} of this NetOwner.
     *
     * @return the {@link NetInstance} instance owned by this NetOwner.
     */
    NetInstance getNet();
}
