package de.renew.watch;

import java.util.Iterator;

/**
 * The ChannelWatcher listens to the workflow request channel to create activities and notify the action executors about changes on the available work items.
 */
public interface ChannelWatcher {

    /**
     * Notifies the watcher about possible bindings for the first, the early argument of the channel. The watcher then notifies the action executors.
     *
     * @param iter An iterator of the early bindings.
     */
    void bindingsCalculated(Iterator<Object> iter);
}
