package de.renew.watch;

import java.util.Iterator;

/**
 * Implementation of the {@link ChannelWatcher} to print debug messages when bindings were calculated.
 */
public class PrintWatcher implements ChannelWatcher {

    /**
     * The logger.
     */
    public static org.apache.log4j.Logger _logger =
        org.apache.log4j.Logger.getLogger(PrintWatcher.class);

    /**
     * Constructs a new {@code PrintWatcher} instance.
     */
    public PrintWatcher() {}

    @Override
    public void bindingsCalculated(Iterator<Object> iterator) {
        _logger.debug("==================== Bindings calculated =====================");

        while (iterator.hasNext()) {
            _logger.debug(iterator.next());
        }

        _logger.debug("==================== Bindings listed =========================");
    }
}
