package de.renew.watch;


import de.renew.application.SimulatorExtensionAdapter;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginProperties;
import de.renew.simulator.api.SimulatorExtensions;
import de.renew.simulatorontology.simulation.SimulationEnvironment;


/**
 * The watch plugin supports the observation and control of
 * activated transitions in a simulation.
 *
 * WatchPlugin.java
 * Created: Mon Jul 21  2003
 *
 * @author Michael Duvigneau
 * @since Renew 2.0
 */
public class WatchPlugin extends PluginAdapter {
    /**
     * The logger.
     */
    public static org.apache.log4j.Logger _logger =
        org.apache.log4j.Logger.getLogger(WatchPlugin.class);

    /**
     * Our simulator extension.
     **/
    private WatchExtension _watchExtension;

    /**
     * Creates an instance of the watch plugin object.
     *
     * @param props   this <code>PluginProperties</code> object
     *                contains the plugin's meta information.
     **/
    public WatchPlugin(PluginProperties props) {
        super(props);
    }

    /**
     * Registers the watch extension with the simulator plugin.
     **/
    @Override
    public void init() {
        this._watchExtension = new WatchExtension();
        SimulatorExtensions.addExtension(_watchExtension);
    }

    /**
     * Unregisters the watch extension from the simulator plugin.
     **/
    @Override
    public boolean cleanup() {
        if (_watchExtension != null) {
            SimulatorExtensions.removeExtension(_watchExtension);
            _watchExtension = null;
        }
        return true;
    }

    /**
     * Resets the channel supervisor every time the simulation is
     * set up or terminated.
     **/
    private class WatchExtension extends SimulatorExtensionAdapter {
        @Override
        public void simulationSetup(SimulationEnvironment env) {
            _logger.debug("WatchPlugin: Resetting channel supervisor.");
            //FIXME: This is too early.  The simulator has probably not
            //       been started yet.  In the case of a restored simulation
            //       state, the simulation objects are not complete at this
            //       point of time.  We need a different event like 
            //       'simulation started'...
            ChannelSupervisor.activate();
        }

        @Override
        public void simulationTerminated() {
            _logger.debug("WatchPlugin: Resetting channel supervisor.");
            ChannelSupervisor.reset();
        }
    }
}
