package de.renew.navigator;

import CH.ifa.draw.util.Command;


/**
 * This is the OpenInNavigatorCommand class to open the Navigator and a JFileChooser.
 *
 * @author Hannes Ahrens (4ahrens)
 * @version March 2009
 */
public class OpenInNavigatorCommand extends Command {
    private final NavigatorPlugin _plugin;

    /**
     * Constructor to create an instance of OpenInNavigatorCommand.
     *
     * @param plugin the NavigatorPlugin to call on execution
     */
    public OpenInNavigatorCommand(NavigatorPlugin plugin) {
        super("Open in Navigator...");
        _plugin = plugin;
    }

    /**
     * Calls the NavigatorPlugin.openInNavigator() method on execution.
     */
    @Override
    public void execute() {
        _plugin.openNavigator();
    }
}