package de.renew.navigator.events;

import de.renew.navigator.gui.FileTreeNode;


/**
 * @author Konstantin Simon Maria Moellers
 * @version 2015-10-26
 */
public class DirectoryOpeningEvent {
    private final boolean _opening;
    private final FileTreeNode _node;

    /**
     * Constructor for creating a DirectoryOpeningEvent object.
     * Represents an event triggered when a directory is opened or closed.
     *
     * @param opening a boolean indicating whether the directory is opening (true) or closing (false)
     * @param node the FileTreeNode representing the directory associated with the event
     */
    public DirectoryOpeningEvent(boolean opening, FileTreeNode node) {
        this._opening = opening;
        this._node = node;
    }

    /**
     * @return is the directory opening or closing?
     */
    public boolean isOpening() {
        return _opening;
    }

    /**
     * @return node that represents the directory
     */
    public FileTreeNode getNode() {
        return _node;
    }
}