package de.renew.navigator.gui;


/**
 * @author Konstantin Simon Maria Moellers
 * @version 2015-08-26
 */
public interface NavigatorIcons {
    // Path
    /**
     * Constant representing the path to the directory for the navigator icons.
     */
    String IMAGES = "/de/renew/navigator/images/";

    // Tool icons
    /**
     * Constant representing the path to the icon used for adding new elements.
     */
    String ICON_ADD = IMAGES + "add.png";
    /**
     * Constant representing the path for the icon used for collapsing the navigator
     */
    String ICON_COLLAPSE_ALL = IMAGES + "collapse.png";
    /**
     * Constant representing the path to the icon used for expanding tree nodes recursively.
     */
    String ICON_EXPAND_RECURSIVE = IMAGES + "expand.png";
    /**
     * Constant representing the path to the "bookmarks.png" icon used in network-related contexts.
     */
    String ICON_NETPATH = IMAGES + "bookmarks.png";
    /**
     * Constant representing the path to the icon used for refreshing all elements in the navigator.
     */
    String ICON_REFRESH_ALL = IMAGES + "refresh_all.png";
    /**
     * Constant representing the path to the icon used for removing all elements in the navigator.
     */
    String ICON_REMOVE_ALL = IMAGES + "remove_all.png";
    /**
     * Constant representing the path to the icon used for removing one element in the navigator.
     */
    String ICON_REMOVE_ONE = IMAGES + "remove.png";
    /**
     * Constant representing the path to the icon used for visually representing the "home" functionality.
     */
    String ICON_HOME = IMAGES + "home.png";
    /**
     * Constant representing the path to the icon used for clearing all filters in the navigator.
     */
    String CLEAR = IMAGES + "clear.png";

    // Files
    /**
     * Constant representing the path to the icon used for unrecognized files.
     */
    String FILE = IMAGES + "files/file.png";
    /**
     * Constant representing the path to the icon used for aip-files.
     */
    String FILE_AIP = IMAGES + "files/file-aip.png";
    /**
     * Constant representing the path to the icon used for ant-files.
     */
    String FILE_ANT = IMAGES + "files/file-ant.png";
    /**
     * Constant representing the path to the icon used for arm-files.
     */
    String FILE_ARM = IMAGES + "files/file-arm.png";
    /**
     * Constant representing the path to the icon used for draw-files.
     */
    String FILE_DRAW = IMAGES + "files/file-draw.png";
    /**
     * Constant representing the path to the icon used for net-files.
     */
    String FILE_NET = IMAGES + "files/file-net.png";
    /**
     * Constant representing the path to the icon used for xml-files.
     */
    String FILE_XML = IMAGES + "files/file-xml.png";
    /**
     * Constant representing the path to the icon used for java-files.
     */
    String FILE_JAVA = IMAGES + "files/file-java.png";
    /**
     * Constant representing the path to the icon used for markdown-files.
     */
    String FILE_MARKDOWN = IMAGES + "files/file-markdown.png";
    /**
     * Constant representing the path to the icon used for dc-files.
     */
    String FILE_DC = IMAGES + "files/file-dc.png";
    /**
     * Constant representing the path to the icon used for ontology-files.
     */
    String FILE_ONTOLOGY = IMAGES + "files/file-ontology.png";

    // Directories
    /**
     * Constant representing the path to the icon of a closed directory pile.
     */
    String PILE_CLOSED = IMAGES + "directories/pile-closed.png";
    /**
     * Constant representing the path to the icon of an opened directory pile.
     */
    String PILE_OPENED = IMAGES + "directories/pile-opened.png";
    /**
     * Constant representing the path to the icon of a closed blue directory.
     */
    String BLUE_CLOSED = IMAGES + "directories/blue-closed.png";
    /**
     * Constant representing the path to the icon of an opened blue directory.
     */
    String BLUE_OPENED = IMAGES + "directories/blue-opened.png";
    /**
     * Constant representing the path to the icon of a closed green directory.
     */
    String GREEN_CLOSED = IMAGES + "directories/green-closed.png";
    /**
     * Constant representing the path to the icon of an opened green directory.
     */
    String GREEN_OPENED = IMAGES + "directories/green-opened.png";
    /**
     * Constant representing the path to the icon of a closed plugin directory.
     */
    String PLUGIN_CLOSED = IMAGES + "directories/plugin-closed.png";
    /**
     * Constant representing the path to the icon of an opened plugin directory.
     */
    String PLUGIN_OPENED = IMAGES + "directories/plugin-opened.png";
    /**
     * Constant representing the path to the icon of a package directory.
     */
    String PACKAGE = IMAGES + "directories/package.png";

    /**
     * Returns the path to the icon with the given name.
     *
     * @param iconName The name of the icon.
     * @return The path to the icon.
     */
    default String getIconPath(String iconName) {
        return IMAGES + iconName;
    }
}