package de.renew.navigator.gui.actions;

import java.awt.event.ActionEvent;

import de.renew.navigator.NavigatorAction;
import de.renew.navigator.NavigatorGui;
import de.renew.navigator.gui.NavigatorIcons;


/**
 * @author Konstantin Simon Maria Moellers
 * @version 2015-08-26
 */
public class ExpandAction extends NavigatorAction {
    /**
     * A reference to the NavigatorGui instance responsible for handling GUI interactions
     * in the navigation system.
     */
    private final NavigatorGui _gui;

    /**
     * Constructs the ExpandAction for expanding the complete folder structure in the navigation GUI.
     *
     * @param gui the NavigatorGui instance on which the action will be performed
     */
    public ExpandAction(final NavigatorGui gui) {
        super("Expand complete folder structure", NavigatorIcons.ICON_EXPAND_RECURSIVE, null);
        this._gui = gui;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        _gui.expand();
    }
}