package de.renew.navigator.gui.filters;

import java.awt.event.ActionEvent;

import de.renew.navigator.NavigatorAction;
import de.renew.navigator.models.NavigatorFileTree;
import de.renew.navigator.models.SearchFilter;


/**
 * @author Konstantin Simon Maria Moellers
 * @version 2015-11-02
 */
public abstract class AbstractFilterAction extends NavigatorAction {
    /**
     * Represents the search filter used by this action for processing and filtering
     * files or content based on specific constraints such as terms, type, and case sensitivity.
     */
    private final SearchFilter _searchFilter;
    /**
     * Represents the instance of the file tree model used for navigation and filtering within
     * the application. This model maintains the structure, active file filters, and background
     * tasks for managing file navigation functionalities.
     */
    private final NavigatorFileTree _fileTree;

    /**
     * Constructor for the AbstractFilterAction.
     *
     * @param searchFltr the search filter to be used
     * @param iconName   the icon name to be used
     * @param navigatorFileTree the navigator file tree to be used
     */
    public AbstractFilterAction(
        SearchFilter searchFltr, String iconName, NavigatorFileTree navigatorFileTree)
    {
        super(nameByFilter(searchFltr), iconName, null);
        this._searchFilter = searchFltr;
        this._fileTree = navigatorFileTree;
    }

    private static String nameByFilter(SearchFilter searchFilter) {
        return searchFilter.getName();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final String name = nameByFilter(_searchFilter);
        final boolean doActivate = _fileTree.getFileFilterByName(name) == null;
        this.putValue("active", doActivate);

        if (doActivate) {
            _fileTree.activateFileFilter(_searchFilter);
            _fileTree.notifyObservers();
            return;
        }

        _fileTree.deactivateFileFilter(name);
        _fileTree.notifyObservers();
    }
}