package de.renew.navigator.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.Action;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import de.renew.navigator.NavigatorGui;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;

class ExpandActionTest {
    private NavigatorGui gui;
    private ExpandAction action;

    @BeforeEach
    void setUp() {
        gui = mock(NavigatorGui.class);
        action = new ExpandAction(gui);
    }

    @Test
    void invokesExpand() {
        action.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, null));
        verify(gui).expand();
    }

    @Test
    void returnsActionName() {
        assertEquals("Expand", action.getActionName());
    }

    @Test
    void hasTooltipDescription() {
        assertEquals("Expand complete folder structure", action.getValue(Action.SHORT_DESCRIPTION));
    }
}