package de.renew.navigator.models;

import org.junit.jupiter.api.Test;

import de.renew.util.RunQueue;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotEquals;


/**
 * @author 1schende and 1jkoeste
 */
class BackgroundTaskTest {
    @Test
    public void testSetName() {
        //given
        final BackgroundTask task1 = new BackgroundTask("task name");
        //when
        task1.setName("new name");
        //then
        assertEquals("new name", task1.getName());
        assertNotEquals("task name", task1.getName());
    }

    @Test
    public void testSetCurrent() {
        //given
        final BackgroundTask task1 = new BackgroundTask("task name");
        //when
        task1.setCurrent(2);
        //then
        assertEquals(2, task1.getCurrent());
        assertNotEquals(3, task1.getCurrent());
    }

    @Test
    public void testSetCancelAction() {
        //given
        final BackgroundTask task1 = new BackgroundTask("task name");
        final Runnable cancelAction1 = new RunQueue();
        //when
        task1.setCancelAction(cancelAction1);
        //then
        assertEquals(cancelAction1, task1.getCancelAction());
    }

    @Test
    public void testIncreaseCurrent() {
        //given
        final BackgroundTask task1 = new BackgroundTask("task name");
        task1.setCurrent(3);
        //when
        task1.increaseCurrent(2);
        //then
        assertEquals(5, task1.getCurrent());
        assertNotEquals(3, task1.getCurrent());
    }
}