<!-- Adapted from: https://www.writethedocs.org/guide/writing/beginners-guide-to-docs/ -->

# NavigatorDiff

## User Guide

_NavigatorDiff_ adds the integration of the drawing’s diff feature into the _Navigator_ plugin. This can be helpful when you want to compare two drawings using the _Navigator_.

### Features

- compare files selected from the Navigator.

### Example Usage

1. Open the Navigator (Ctrl+Shift-N).
2. Select two files.
3. Click on the Diffs two files Icon in the Navigator bar.
4. Inspect the generated difference image of both. 

### Provided Commands

<!-- Use the classes implementing CLCommand. The 'help' output of the command can be a useful description -->

- _NavigatorDiff_ does not provide any Commands.
### Installation

Install _NavigatorDiff_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew.

### Dependencies

This plugin depends on the following plugins and external libraries:

<!-- must match the `module-info.java` -->

- `Navigator`: Used to add _NavigatorDiff_ to the Navigator bar 
- `CH`: Adds the functionality to open files/drawings.
- `ImageNetDiff`: Provides the Command to compare the files.

### Configuration

During the initialization of _NavigatorDiff_, no properties are read from the `renew.properties` file in the Renew root directory.

## Developer Guide

### Core Classes

- `NavigatorDiffPlugin`:Extends the `DIPlugin` (which Implements the `IPlugin` interface) to manage the startup and shutdown.
- `FileDifferImpl`: Opens and Compares the two files.
- `FileDiffAction`: Extends `NavigatorAction` and calls the method of `FileDifferImpl` to compare the files.

### How to Extend

_Navigator_ exposes one Interface, `FileDiffer`. You can implement this interface to add additional functionality to the Diff.

### Additional Information

<!-- Common issues, explanations for inconsistencies, etc. -->

- Because _NavigatorDiff_ uses `PNGDiffCommand` ImageMagick has to be installed in the system for _NavigatorDiff_ to run as intended.
<!-- Contribution Info -->

<!-- License -->
