package de.renew.navigator.diff;

import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;

import de.renew.navigator.NavigatorConfigurator;
import de.renew.navigator.NavigatorExtension;
import de.renew.navigator.NavigatorGui;
import de.renew.navigator.NavigatorPlugin;
import de.renew.plugin.annotations.Inject;
import de.renew.plugin.annotations.Provides;
import de.renew.plugin.di.DIPlugin;


/**
 * @author Konstantin Simon Maria Möllers
 * @version 0.1
 */
public class NavigatorDiffPlugin extends DIPlugin implements NavigatorExtension {
    private final FileDiffer _fileDiffer;
    private final FileDiffAction _fileDiffAction;
    private final NavigatorGui _gui;

    @Inject
    public NavigatorDiffPlugin(NavigatorPlugin plugin, NavigatorGui gui) {
        this._gui = gui;
        _fileDiffer = new FileDifferImpl();
        _fileDiffAction = new FileDiffAction(plugin, _fileDiffer);

        gui.addExtension(this);
    }

    @Override
    public boolean cleanup() {
        return _gui.removeExtension(this);
    }

    @Override
    public void configure(NavigatorConfigurator config) {
        config.addMenuAction(_fileDiffAction);
    }

    @Override
    public JMenuItem getMenuItem(
        JTree tree, int x, int y, Object lastPathComponent, MutableTreeNode mtn)
    {
        return null;
    }

    @Provides
    public FileDiffer getFileDiffer() {
        return _fileDiffer;
    }
}