package de.renew.navigator.vc;

import java.util.Date;

import de.renew.logging.CliColor;


/**
 * @author Konstantin Simon Maria Möllers
 * @version 0.1
 */
public class Commit {
    private static final long LONG_DATE = 1000L;
    private static final String STRING_TO_BE_COLORED = "$1";
    private String _revision;
    private String _message;
    private String _author;
    private Date _date;

    /**
     * Gets the revision identifier.
     *
     * @return _revision the String of the identifier.
     */
    public String getRevision() {
        return _revision;
    }

    /**
     * Sets the revision identifier.
     *
     * @param revision the String identifier to set.
     */
    public void setRevision(String revision) {
        this._revision = revision;
    }

    /**
     * Gets the message associated with this object.
     *
     * @return _message the String of the message.
     */
    public String getMessage() {
        return _message;
    }

    /**
     * Sets the message associated with this object.
     *
     * @param message the String message to set.
     */
    public void setMessage(String message) {
        this._message = message;
    }

    /**
     * Gets the author of this object.
     *
     * @return _author the String of the author's name.
     */
    public String getAuthor() {
        return _author;
    }

    /**
     * Sets the author of this object.
     *
     * @param author the String of the author's name to set.
     */
    public void setAuthor(String author) {
        this._author = author;
    }

    /**
     * Gets the date associated with this object.
     *
     * @return _date the Date of the object.
     */
    public Date getDate() {
        return _date;
    }

    /**
     * Sets the date associated with this object.
     *
     * @param date the Date to set.
     */
    public void setDate(Date date) {
        this._date = date;
    }

    /**
     * Sets the date of the object.
     *
     * @param date the int representing the passed seconds since the epoch.
     */
    public void setDate(int date) {
        this._date = new Date(date * LONG_DATE);
    }

    /**
     * Formats a commit message according to Renew / Paose rules.
     *
     * @param message the String message to be formatted.
     * @return the formatted message.
     */
    @SuppressWarnings("SpellCheckingInspection")
    public static String formatMessage(String message) {
        message = message.replaceAll("\\n\\* ", "\n• ");
        message = message
            .replaceAll("\\*([^*\\n]+)\\*", CliColor.color(STRING_TO_BE_COLORED, CliColor.BOLD));
        message = message.replaceAll(
            "\\+([^+\\n]+)\\+", CliColor.color(STRING_TO_BE_COLORED, CliColor.UNDERLINE));
        message = message
            .replaceAll("_([^_\\n]+)_", CliColor.color(STRING_TO_BE_COLORED, CliColor.ITALIC));
        message = message.replaceAll(
            "-([^\\-\\n]+)-", CliColor.color(STRING_TO_BE_COLORED, CliColor.CROSSED_OUT));
        message =
            message.replaceAll("@([^@\\n]+)@", CliColor.color(STRING_TO_BE_COLORED, CliColor.CYAN));
        return message;
    }
}