package de.renew.netcomponents;

import de.renew.draw.ui.ontology.AbstractCommand;
import de.renew.plugin.IPlugin;


/**
 * The command that is executed for showing the netcomponents.
 *
 * @author Lawrence Cabac
 */
public class ShowNetComponentsToolCommand extends AbstractCommand {
    IPlugin _plugin;
    private String _toolsDirPropertyName;
    private String _menutext;
    private ComponentsPluginExtender _pluginPlugin;

    /**
     * The constructor takes a plugin, the menutext and the path to the tools directory
     * to creates a new Instance of "ShowNetComponentsToolCommand"
     *
     * @param plugin a generic plugin
     * @param menutext the menutext for the plugin
     * @param toolsDir the path to the tools directory
     */
    public ShowNetComponentsToolCommand(IPlugin plugin, String menutext, String toolsDir) {
        super(menutext);
        _plugin = plugin;
        _toolsDirPropertyName = toolsDir;
        _menutext = menutext;
        _pluginPlugin = null;

    }

    /**
     * The constructor takes a plugin, the menutext and the path to the tools directory
     * as well as a List of Commands that can be added to the menu
     * to creates a new Instance of "ShowNetComponentsToolCommand"
     *
     * @param plugin a generic plugin
     * @param menutext the menutext for the plugin
     * @param toolsDir the path to the tools directory
     * @param pluginPlugin a List of commands that can be added to the menu
     */
    public ShowNetComponentsToolCommand(
        IPlugin plugin, String menutext, String toolsDir, ComponentsPluginExtender pluginPlugin)
    {
        super(menutext);
        _plugin = plugin;
        _toolsDirPropertyName = toolsDir;
        _menutext = menutext;
        _pluginPlugin = pluginPlugin;

    }

    /**
     * Shows the Net Components Tools Palette
     *
     * @see AbstractCommand#execute()
     */
    @Override
    public void execute() {
        ComponentsToolPlugin ctp = (ComponentsToolPlugin) _plugin;
        ctp.createPalette(_toolsDirPropertyName, _menutext, _pluginPlugin);
    }
}