# P/T net formalism with synchronous channels

## User Guide

_PTChannel_ introduces a net formalism which enables transitions in P/T nets 
to communicate with each other via synchronous channels.

### Features

- A compiler to compile nets using the P/T channel formalism

### Example Usage

1. Open a P/T channel net (e.g. MultipleCommunicatingSenderReceiver.rnw in samples folder) in the graphical editor.
2. Select the P/T Net with Channel Compiler under _Simulation > P/T Net with Channel Compiler_.
3. Compile and simulate the net under _Simulation > Run Simulation_.

### Installation

Using the Gradle Wrapper:

* If all dependencies are fulfilled:
  `$./gradlew ptchannel:plugin`

* If dependencies are not fulfilled:
  `$./gradlew ptchannel:minimal` or build them manually:
  `$./gradlew loader:plugin util:plugin simulator:plugin formalism:plugin gui:plugin`

### Dependencies

This plugin depends on the following plugins:

- `Simulator`
- `Formalism`
- `Util`

## Developer Guide

### Core Classes

- `PTChannelPlugin`: Implements the `PluginAdapter` interface to manage startup, 
shutdown and registration of the compiler at the compiler factory.
- `SinglePTNetWithChannelCompiler`: A P/T net compiler which gets extended to compile
transition and arc inscriptions, enabling synchronous communication.
- `PTCTransitionCompiler`: Java net compiler that is responsible for 
compiling arc and transition inscriptions.
- 
### How to Extend

If extended, e.g. by the possibility of synchronizing different net instances,
the `PTCUnfolder` in the `PropertyChecker` plugin should be extended as well, 
to always assure that a P/T net with channels can be unfolded 
to an ordinary P/T net. If that cannot be done, a new compiler 
which inherits the `SinglePTNetWithChannelCompiler`
should be used, instead of extending the existing one.

### Provided Commands

Currently none.

### Additional Information

A more detailed user guide with examples can be found at
the [module's confluence page](https://tgipm.informatik.uni-hamburg.de/confluence/display/RENEW/PTChannel+Plugin).

This module is depending on how net elements get parsed by the JavaNetParser.jj
in Renew's Formalism plugin.
Thus, if the way of parsing in Renew gets changed, this module is likely to break.
If that is the case, three methods likely need to be adopted to the new
way of parsing:
`buildListTokenInscription()`, `getInscriptionIntegerValues()` and `getInscriptionVariables()`.
This is a case of the bad smell "Shotgun Surgery".
But this plugin is not the only one depending on the way of parsing.
Because of that, it has not been changed for over a decade now.