package de.renew.ptchannel.nin;

import java.util.Collection;

import de.renew.net.Place;
import de.renew.net.inscription.TransitionInscription;
import de.renew.ptchannel.single.SinglePTNetWithChannelCompiler;
import de.renew.simulatorontology.shadow.ShadowArc;
import de.renew.simulatorontology.shadow.ShadowDeclarationNode;
import de.renew.simulatorontology.shadow.ShadowInscription;
import de.renew.simulatorontology.shadow.ShadowNet;
import de.renew.simulatorontology.shadow.ShadowPlace;
import de.renew.simulatorontology.shadow.SyntaxException;


/**
 * This is the compiler for P/T nets which can communicate
 * with other net instances.
 * The only thing it does is delegating all
 * compilations to its parent class, except for system nets,
 * which get compiled with a {@link de.renew.formalism.java.JavaNetCompiler}.
 *
 * @author Lukas Voß
 */
public class SinglePTNetInNetCompiler extends SinglePTNetWithChannelCompiler {

    /**
     * The name of the system net.
     */
    public static final String SYSTEM_NET = "SystemNet";

    /**
     * Creates a new <code>SinglePTNetInNetCompiler</code> instance.
     */
    public SinglePTNetInNetCompiler() {
        super();
    }

    @Override
    public String checkTransitionInscription(
        String inscription, boolean special, ShadowNet shadowNet) throws SyntaxException
    {
        if (shadowNet.getName().equals(SYSTEM_NET)) {
            return super.getTransitionCompiler()
                .checkTransitionInscription(inscription, special, shadowNet);
        } else {
            return super.checkTransitionInscription(inscription, special, shadowNet);
        }
    }

    @Override
    public String checkPlaceInscription(String inscription, boolean special, ShadowNet shadowNet)
        throws SyntaxException
    {
        if (shadowNet.getName().equals(SYSTEM_NET)) {
            return super.getTransitionCompiler()
                .checkPlaceInscription(inscription, special, shadowNet);
        } else {
            return super.checkPlaceInscription(inscription, special, shadowNet);
        }
    }

    @Override
    public String checkArcInscription(String inscription, boolean special, ShadowNet shadowNet)
        throws SyntaxException
    {
        if (shadowNet.getName().equals(SYSTEM_NET)) {
            return super.getTransitionCompiler()
                .checkArcInscription(inscription, special, shadowNet);
        } else {
            return super.checkArcInscription(inscription, special, shadowNet);
        }
    }

    @Override
    protected void compilePlaceInscriptions(ShadowPlace shadowPlace, Place place)
        throws SyntaxException
    {
        if (shadowPlace.getNet().getName().equals(SYSTEM_NET)) {
            super.getTransitionCompiler().compilePlaceInscriptions(shadowPlace, place);
        } else {
            super.compilePlaceInscriptions(shadowPlace, place);
        }
    }

    @Override
    protected void compileArc(ShadowArc shadowArc) throws SyntaxException {
        if (shadowArc.getNet().getName().equals(SYSTEM_NET)) {
            super.getTransitionCompiler().compileArc(shadowArc, lookup);
        } else {
            super.compileArc(shadowArc);
        }
    }

    @Override
    protected Collection<TransitionInscription> compileTransitionInscription(
        ShadowInscription inscription) throws SyntaxException
    {
        if (inscription.getNet().getName().equals(SYSTEM_NET)) {
            return super.getTransitionCompiler().compileTransitionInscription(inscription, lookup);
        } else {
            return super.compileTransitionInscription(inscription);
        }
    }

    /**
     * Compiles all declarations of the given net.
     *
     * @param shadowNet the net whose declarations should be compiled
     * @throws SyntaxException when a syntax exception occurs
     */
    public void parseDeclarations(ShadowNet shadowNet) throws SyntaxException {
        if (shadowNet.getName().equals(SYSTEM_NET)) {
            super.getTransitionCompiler().parseDeclarations(shadowNet);
        } else {
            super.parseDeclarations(shadowNet);
        }
    }

    protected ShadowDeclarationNode findDeclarationNode(ShadowNet shadowNet)
        throws SyntaxException
    {
        if (shadowNet.getName().equals(SYSTEM_NET)) {
            return super.getTransitionCompiler().findDeclarationNode(shadowNet);
        } else {
            return super.findDeclarationNode(shadowNet);
        }
    }
}
