package de.renew.plugindevelopment;

import java.net.URL;
import java.util.Vector;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.util.CommandMenu;
import de.renew.draw.ui.api.MenuApi;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.command.CLCommand;
import de.renew.plugindevelopment.commands.CreateApplicationStructureCommand;
import de.renew.plugindevelopment.generating.LibraryPluginGenerator;
import de.renew.plugindevelopment.generating.StandardPluginGenerator;

/**
 * Facade for the PluginDevelopment Plugin for Renew.
 * 0.1 Adapted from UseCaseComponents
 * 0.2 Fixed prompting for sources
 *
 * @author Lawrence Cabac
 * @version 0.2
 */
public class PluginDevelopmentPlugin extends PluginAdapter {

    /**
     * The toolsdir property name.
     */
    //protected static String TOOLDIRPROPERTY = "de.renew.nc.usecase.dir";
    static private URL _location;

    /**
     * Constructs a new PluginDevelopmentPlugin with the given location URL.
     *
     * @param location The URL location of the plugin.
     * @throws PluginException If there is an issue with the plugin.
     */
    public PluginDevelopmentPlugin(URL location) throws PluginException {
        super(location);

        setLocation(location);

    }

    /**
     * Constructs a new PluginDevelopmentPlugin with the given properties.
     *
     * @param props The properties of the plugin.
     */
    public PluginDevelopmentPlugin(PluginProperties props) {
        super(props);

        setLocation(props.getURL());
    }

    @Override
    public void init() {
        DrawPlugin current = DrawPlugin.getCurrent();
        if (current == null) {
            return;
        }
        CommandMenu menu = new CommandMenu("Plugin Development");
        menu.putClientProperty(MenuApi.ID_PROPERTY, "de.renew.plugindevelopment");
        menu.add(
            new CreateApplicationStructureCommand(
                "Create Renew Plugin Folder", new StandardPluginGenerator()));
        menu.add(
            new CreateApplicationStructureCommand(
                "Create Renew Library Plugin Folder", new LibraryPluginGenerator()));
        MenuApi.registerMenu(DrawPlugin.PLUGINS_MENU, menu);
    }

    @Override
    public boolean cleanup() {
        return true;
    }

    /**
     * Gets the location URL of the plugin.
     *
     * @return The location URL of the plugin.
     */
    static public URL getLocation() {
        return _location;
    }

    /**
     * Sets the location URL of the plugin.
     *
     * @param url The location URL to set.
     */
    static public void setLocation(URL url) {
        _location = url;
    }

    /**
     * Retrieves a vector of command-line commands associated with this PluginDevelopmentPlugin.
     * Currently, it returns null, indicating that no prompt commands are defined for this plugin.
     *
     * @return A vector of command-line commands or null if none are defined.
     */
    public Vector<CLCommand> getPromptCommands() {
        return null;
    }
}