package de.renew.propertymanagement.prop;

import javax.swing.KeyStroke;

/**
 * Extension of {@link ConfigurableProperty} that deals with hotkeys specifically.
 *
 * @author 0schult
 */
public class ConfigurableHotkeyProperty extends ConfigurableProperty {
    private KeyStroke _keyStroke;

    /**
     * Creates a new {@link ConfigurableHotkeyProperty} with the given initial value.
     *
     * @param key the key for this property
     * @param keyStroke the default hotkey for this property
     * @param pluginName the name of the plugin that is registering this property
     * @param displayName the name that should be displayed for this property
     */
    public ConfigurableHotkeyProperty(
        String key, KeyStroke keyStroke, String pluginName, String displayName)
    {
        super(key, keyStroke.toString(), pluginName, displayName, null);
        _keyStroke = keyStroke;
    }

    /**
     * Get the current hotkey for this property.
     *
     * @return the {@link KeyStroke} for this property
     */
    public KeyStroke getKeyStroke() {
        return _keyStroke;
    }

    /**
     * Set the hotkey for this property.
     *
     * @param keyStroke the new {@link KeyStroke} for this property
     */
    public void setKeyStroke(KeyStroke keyStroke) {
        _keyStroke = keyStroke;
    }
}
