package de.renew.propertymanagementgui.commands;

import de.renew.draw.ui.ontology.AbstractCommand;
import de.renew.propertymanagementgui.controller.SettingsController;


/**
 * Command to open the settings window.
 */
public class OpenSettingsWindowCommand extends AbstractCommand {

    private static final String MENU_NAME = "Plugin Settings";

    /**
     * Creates a new OpenSettingsWindowCommand.
     */
    public OpenSettingsWindowCommand() {
        super(MENU_NAME);
    }

    @Override
    public void execute() {
        SettingsController settingsController = new SettingsController();
        settingsController.openSettingsWindow();
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    @Override
    public void setIsExecutable(boolean executable) {
        super.setIsExecutable(executable);
    }
}
