package de.renew.propertymanagementgui.gui;

import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;

import de.renew.propertymanagementgui.reactivecomponents.Component;


/**
 * The Button to close the settings window.
 */
public class CloseButtonComponent extends Component {

    private final ActionListener _closeWindowAction;

    /**
     * Creates a new CloseButtonComponent.
     *
     * @param closeWindowActionListener The listener that will be called to close the window, when the button is clicked.
     */
    public CloseButtonComponent(ActionListener closeWindowActionListener) {
        this._closeWindowAction = closeWindowActionListener;
    }

    @Override
    protected JComponent render() {
        JButton cancelButton = new JButton("Close");
        cancelButton.addActionListener(_closeWindowAction);
        return cancelButton;
    }
}
