package de.renew.propertymanagementgui.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

import de.renew.propertymanagementgui.reactivecomponents.Component;


/**
 * This class represents a plugin navigation component in the settings window.
 * It is responsible for rendering a single navigation item in the side navigation panel.
 * Each navigation item represents a plugin and is associated with a {@link Runnable} action that is executed when the item is clicked.
 */
public class PluginNavigationComponent extends Component {
    private static final int PLUGIN_NAV_HEIGHT = 20;

    private final String _pluginName;
    private final Runnable _action;

    /**
     * Creates a new PluginNavigationComponent.
     *
     * @param pluginName The name of the plugin.
     * @param action     The action to be performed when the item is clicked.
     */
    protected PluginNavigationComponent(String pluginName, Runnable action) {
        _pluginName = pluginName;
        _action = action;
    }

    @Override
    protected JComponent render() {
        JComponent pluginNav = new JPanel(new GridBagLayout());
        pluginNav.setPreferredSize(new Dimension(Integer.MAX_VALUE, PLUGIN_NAV_HEIGHT));
        pluginNav.setMaximumSize(new Dimension(Integer.MAX_VALUE, PLUGIN_NAV_HEIGHT));
        Color originalColor = pluginNav.getBackground();
        Color hoverColor = Color.LIGHT_GRAY;
        JLabel label = new JLabel(_pluginName);

        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbc.anchor = GridBagConstraints.CENTER;

        pluginNav.add(label, gbc);
        pluginNav.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(MouseEvent e) {
                _action.run();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                pluginNav.setBackground(hoverColor); // Change background color when mouse enters
            }

            @Override
            public void mouseExited(MouseEvent e) {
                pluginNav.setBackground(originalColor); // Change background color back to original when mouse exits
            }
        });
        return pluginNav;
    }
}
