package de.renew.propertymanagementgui.gui;

import javax.swing.JButton;
import javax.swing.JComponent;

import de.renew.propertymanagementgui.reactivecomponents.Component;


/**
 * This class represents the save button component of the settings window.
 * It is responsible for rendering a JButton with the text "Save" and adding an ActionListener to it.
 */
public class SaveButtonComponent extends Component {

    //The Local action is: _propertyManager.saveProperties(false);
    private final Runnable _savePropertiesAction;

    //The label of the button
    private final String _label;

    /**
     * Creates a new SaveButtonComponent.
     *
     * @param savePropertiesAction The action to be performed when the button is clicked.
     * @param label The label of the button.
     */
    public SaveButtonComponent(Runnable savePropertiesAction, String label) {
        _savePropertiesAction = savePropertiesAction;
        _label = label;
    }

    /**
     * This method creates a JButton with the text "Save" and adds an ActionListener to it.
     * @return JButton
     */
    @Override
    protected JComponent render() {
        JButton saveButton = new JButton(_label);
        saveButton.addActionListener(e -> {
            //New File is created under dist/config/renew.properties
            //When the save button is clicked, then we need to get every value from our table
            // and put it into current value of the property
            _savePropertiesAction.run();
        });
        return saveButton;
    }
}
