package de.renew.propertymanagementgui.gui;

import java.awt.BorderLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

import de.renew.propertymanagement.prop.ConfigurableProperty;



/**
 * Unit test class for BodyComponent
 *
 * @author 7kraft
 */
class BodyComponentTest {

    @Test
    public void testRender() throws Exception {
        //given
        Map<String, ConfigurableProperty> props = new HashMap<>();
        Runnable noop = () -> {
        };
        BodyComponent bodyComponent = new BodyComponent(props, noop, noop);

        final JComponent[] rendered = new JComponent[1];

        //when
        SwingUtilities.invokeAndWait(() -> rendered[0] = bodyComponent.render());

        //then
        Assertions.assertThat(rendered[0]).isNotNull();
        Assertions.assertThat(rendered[0]).isInstanceOf(JPanel.class);

        JPanel panel = (JPanel) rendered[0];
        Assertions.assertThat(panel.getLayout()).isInstanceOf(BorderLayout.class);

        BorderLayout layout = (BorderLayout) panel.getLayout();

        java.awt.Component center = layout.getLayoutComponent(BorderLayout.CENTER);
        Assertions.assertThat(center).isNotNull();

        java.awt.Component pageEnd = layout.getLayoutComponent(BorderLayout.PAGE_END);
        if (pageEnd == null) {
            pageEnd = layout.getLayoutComponent(BorderLayout.SOUTH);
        }
        Assertions.assertThat(pageEnd).isNotNull();

        Assertions.assertThat(panel.getComponentCount()).isEqualTo(2);
    }
}