package de.renew.propertymanagementgui.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;


/**
 * Unit test class for CloseButtonComponent
 *
 * @author 7kraft
 */
class CloseButtonComponentTest {

    @Test
    public void testRender() {
        //given
        ActionListener listener = Mockito.mock(ActionListener.class);
        CloseButtonComponent comp = new CloseButtonComponent(listener);

        //when
        JComponent cancelComponent = comp.render();

        //then
        Assertions.assertThat(cancelComponent).isNotNull();
        Assertions.assertThat(cancelComponent).isInstanceOf(JButton.class);

        JButton cancelButton = (JButton) cancelComponent;
        Assertions.assertThat(cancelButton.getText()).isEqualTo("Close");

        ActionListener[] listeners = cancelButton.getActionListeners();
        Assertions.assertThat(listeners.length).isEqualTo(1);
        Assertions.assertThat(listener).isSameAs(listeners[0]);

        cancelButton.doClick();
        Mockito.verify(listener).actionPerformed(ArgumentMatchers.any(ActionEvent.class));
    }
}