package de.renew.propertymanagementgui.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneConstants;

import org.junit.jupiter.api.Test;

import de.renew.propertymanagement.prop.ConfigurableProperty;

import static org.assertj.core.api.Assertions.assertThat;

/**
 * Unit test class for PageComponent.
 *
 * @author 2hohberg
 */
class PageComponentTest {

    @Test
    void testRender() {
        //given
        List<ConfigurableProperty> properties = new ArrayList<>();
        PageComponent pageComponent = new PageComponent(properties);
        JScrollPane jScrollPane = new JScrollPane();
        //when
        JComponent component = pageComponent.render();
        if (component instanceof JScrollPane) {
            jScrollPane = (JScrollPane) component;
        }
        //then
        assertThat(component).isNotNull();
        assertThat(component).isInstanceOf(JScrollPane.class);
        //A scroll pane has JViewport, and two JScrollBars (= 3 components)
        assertThat(component.getComponentCount()).isEqualTo(3);
        // value for not displayed scrollbar
        assertThat(jScrollPane.getHorizontalScrollBarPolicy())
            .isEqualTo(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        // value for needed scrollbar
        assertThat(jScrollPane.getVerticalScrollBarPolicy())
            .isEqualTo(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
        assertThat(jScrollPane.getComponent(1)).isInstanceOf(JScrollBar.class);
        assertThat(jScrollPane.getComponent(2)).isInstanceOf(JScrollBar.class);
        assertThat(jScrollPane.getComponent(0)).isInstanceOf(JViewport.class);
    }

    @Test
    void testRenderNull() {
        //given
        PageComponent pageComponent = new PageComponent(null);
        JScrollPane jScrollPane = new JScrollPane();
        //when
        JComponent component = pageComponent.render();
        if (component instanceof JScrollPane) {
            jScrollPane = (JScrollPane) component;
        }
        //then
        assertThat(component).isNotNull();
        assertThat(component).isInstanceOf(JScrollPane.class);
        //A page component has JPanel, and two JScrollBars (= 3 components)
        assertThat(component.getComponentCount()).isEqualTo(3);
        // value for not displayed scrollbar
        assertThat(jScrollPane.getHorizontalScrollBarPolicy())
            .isEqualTo(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        // value for needed scrollbar
        assertThat(jScrollPane.getVerticalScrollBarPolicy())
            .isEqualTo(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
        assertThat(jScrollPane.getComponent(1)).isInstanceOf(JScrollBar.class);
        assertThat(jScrollPane.getComponent(2)).isInstanceOf(JScrollBar.class);
        assertThat(jScrollPane.getComponent(0)).isInstanceOf(JViewport.class);

        JViewport viewport = jScrollPane.getViewport();
        JPanel page = (JPanel) viewport.getView();
        JLabel jLabel = (JLabel) page.getComponent(0);

        assertThat(jLabel.getText())
            .isEqualTo("<html>Click on a plugin to see its settings.</html>");
    }
}