package de.renew.propertymanagementgui.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;


/**
 * Unit test class for PluginNavigationComponent
 *
 * @author 7kraft
 */
class PluginNavigationComponentTest {

    @Test
    public void testRender() {
        //given
        Runnable action = Mockito.mock(Runnable.class);
        PluginNavigationComponent comp = new PluginNavigationComponent("My Plugin", action);

        //when
        JComponent pluginNav = comp.render();

        //then
        Assertions.assertThat(pluginNav).isNotNull();
        Assertions.assertThat(pluginNav.getLayout()).isInstanceOf(GridBagLayout.class);
        Assertions.assertThat(pluginNav.getPreferredSize())
            .isEqualTo(new Dimension(Integer.MAX_VALUE, 20));
        Assertions.assertThat(pluginNav.getMaximumSize())
            .isEqualTo(new Dimension(Integer.MAX_VALUE, 20));

        Assertions.assertThat(pluginNav.getComponentCount()).isEqualTo(1);
        Assertions.assertThat(pluginNav.getComponent(0)).isInstanceOf(JLabel.class);
        Assertions.assertThat(((JLabel) pluginNav.getComponent(0)).getText())
            .isEqualTo("My Plugin");

        MouseEvent click = new MouseEvent(
            pluginNav, MouseEvent.MOUSE_CLICKED, System.currentTimeMillis(), 0, 0, 0, 1, false);

        for (var listener : pluginNav.getMouseListeners()) {
            listener.mouseClicked(click);
        }
        Mockito.verify(action).run();

        Color original = pluginNav.getBackground();
        MouseEvent enter = new MouseEvent(
            pluginNav, MouseEvent.MOUSE_ENTERED, System.currentTimeMillis(), 0, 0, 0, 0, false);
        MouseEvent exit = new MouseEvent(
            pluginNav, MouseEvent.MOUSE_EXITED, System.currentTimeMillis(), 0, 0, 0, 0, false);

        for (var listener : pluginNav.getMouseListeners())
            listener.mouseEntered(enter);
        Assertions.assertThat(pluginNav.getBackground()).isEqualTo(Color.LIGHT_GRAY);

        for (var listener : pluginNav.getMouseListeners())
            listener.mouseExited(exit);
        Assertions.assertThat(pluginNav.getBackground()).isEqualTo(original);
    }
}