# RENEW

## Table of Contents

[1. Introduction](#toc_0)<br>
[2. User Guide](#toc_1)<br>
&nbsp;&nbsp;&nbsp;&nbsp;[2.1 Installing and Building Renew for Users](#toc_2)<br>
&nbsp;&nbsp;&nbsp;&nbsp;[2.2 Features](#toc_3)<br>
&nbsp;&nbsp;&nbsp;&nbsp;[2.3 Module Design Principles](#toc_4)<br>
&nbsp;&nbsp;&nbsp;&nbsp;[2.4 Release History](#toc_5)<br>
&nbsp;&nbsp;&nbsp;&nbsp;[2.5 Known Bugs](#toc_6)<br>
[3. Developer Guide](#toc_7)<br>
&nbsp;&nbsp;&nbsp;&nbsp;[3.1 Installing and Building Renew for Developers](#toc_8)<br>
&nbsp;&nbsp;&nbsp;&nbsp;[3.2 Code Style](#toc_9)<br>
&nbsp;&nbsp;&nbsp;&nbsp;[3.3 Used Tools](#toc_10)<br>
[4. Additional Information](#toc_11)<br>
&nbsp;&nbsp;&nbsp;&nbsp;[4.1 Gradle](#toc_12)<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[4.1.1 Example Gradle Tasks](#toc_13)<br>
&nbsp;&nbsp;&nbsp;&nbsp;[4.2 Contribution Info](#toc_14)<br>
&nbsp;&nbsp;&nbsp;&nbsp;[4.3 License](#toc_15)


## <a name="toc_0"></a>1. Introduction


Renew is a software that has been (and is still) constantly developed for more than two decades. It provides several drawing tools that can be used to design or simulate the eponymous reference nets (Renew is short for Reference Net Workshop).

These reference nets are models of systems that run in parallel and can communicate with each other and work in a coordinated fashion. Despite the primary focus of Renew on reference nets, it also supports other formalisms like P/T nets and workflow nets.

Renew supports synchronous channels. Channels are a powerful communication mechanism and serve as a reliable abstraction concept.


## <a name="toc_1"></a>2. User Guide


### <a name="toc_2"></a>2.1 Installing and Building Renew for Users

Java 17 (Warning: Renew may fail to build on some higher Java versions) must be installed, as the Java Runtime Environment (JRE) (or an equivalent Java Development Kit) is required to use Renew.

Download the latest version or other versions here: http://www.renew.de/

Unzip the base.zip package, e.g., renew4.2base.zip for Renew 4.2 (it should not be nestled too deep into a maze of other folders or else it will not open), and go to renew4.2.

Open the command line interface and type `java -p .:libs -m de.renew.loader gui` if you use Linux, `.;libs` instead of `.:libs` if you use Windows for version 4.2 or higher, and `java -jar loader.jar gui` for version 2.6.

Alternatively, you can also go to renew(4.2 or 2.6)/bin/YOUR_OS/ to install renew, to then start renew, run renew(4.2 or 2.6)/bin/YOUR_OS/renew.

For documentation, look at the subdirectory in the base package of each version, e.g., `renew4.2/doc`.

For pre-made nets, look at the subdirectory in the base package of each version, e.g., `renew4.2/samples`.

For (adding) plug-ins, look at the subdirectory in the base package of each version, e.g., `renew4.2/plugins`.

For more details, see the installation process of different versions of Renew on: http://www.renew.de/


### <a name="toc_3"></a>2.2 Features

For details, see:
- User Guide of each version on  http://www.renew.de/
- Architecture Guide: Consult the file `doc/architecture.pdf` in the source package after downloading it from the chosen version on http://www.renew.de/


### <a name="toc_4"></a>2.3 Module Design Principles

Renew is based on plug-ins (which are necessary to enable different net types or uses) and can use all Java classes. However, since Renew provides its source code, you can make many changes on your own. Moreover, your feature requests are more likely to be satisfied if you can already provide an implementation. It uses Gradle as a build tool, which will automatically take care of all dependencies.

Notes that:

- No transitive dependencies on renew modules are permitted.
- External modules must not export Renew API packages.

**Project Structure:**

```bash
Renew
├── gradle 
├── Plugin A
│   ├── src
│   │    ├── main  
│   │    │     ├── java
│   │    │     │      └── de.renew.plugina
│   │    │     │            ├── de
│   │    │     │            │    └── renew 
│   │    │     │            │          ├── packagea        
│   │    │     │            │          └── packageb      
│   │    │     │            └── module-info.java     
│   │    │     └── resources  
│   │    │           ├── samples  
│   │    │           └── plugin.cfg  
│   │    └── test
│   ├── build.gradle 
│   ├── gradle.properties
│   └── README.md
├── Plugin B
├── build.gradle  
├── gradle.properties 
├── READEM.md
├── settings.gradle
└── gradlew
```


### <a name="toc_5"></a>2.4 Release History

Renew 1.0 (Alpha version) was released in March 1999 as a network editor and a reference network simulator. It included a Java stub compiler and example networks. The newest release is Renew 4.2.

This table shows an overview of the changes in all releases.

| Releases    | Modifications                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | Additions                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
|-------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Renew 1.1   | -Bugs were fixed, and some performance enhancements were implemented. <br /> -The thread model of Java 1.2 was adopted. <br />-There are more Java versions available for compilation and execution.<br />-The simulator's handling of null-objects has been improved.<br />-The type system has been modified to be more compatible with Java's type system.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | -The Code for parallel simulation was included.<br /> -Checks for cyclic channel dependencies and double names were added. <br />-Virtual places can be employed in nets.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| Renew 1.2   | -Bugs were fixed, and some performance enhancements were implemented. <br /> -The simulation engine was improved to be more robust and flexible.<br /> -A single inscription figure contains multiple arc inscriptions or initial marking inscriptions that are separated by semicolons.<br />-Even in the presence of typed variables, the results of action inscriptions may now be conveyed across synchronous channels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | -Flexible arcs, Clear arcs, and Inhibitor arcs were added.<br />-A rudimentary net layout algorithm has been implemented.<br />-The state of a running simulation can now be saved and restored. Restarting a simulation can now include reloading Java classes.<br />-Export of Encapsulated PostScript was implemented.<br />-The Selection of groups of figures was improved.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| Renew 1.3   | -Some minor GUI improvements have been applied.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | -There is now a timed simulation mode.<br />-Tuples are offered in addition to lists.<br />-Breakpoints to control the graphical simulation.<br /> -A facility for XML import and export was added.<br />-A graph layout algorithm which is useful for displaying nets.<br />-More commands for arranging figures manually.<br />-Ability to select figures by type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| Renew 1.4   | -Maintenance release that provided bug fixes, updates to the documentation, and user interface improvements.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | -Ability to inspect token Java objects in detail and put toolbars into their own window.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| Renew 1.5   | -Small bug fixes in the simulation and throughout the code.<br />-Some minor GUI improvements have been applied.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | -The deployment of the simulator in an environment with high availability requirements is supported by a persistent database back-up.<br />-An Architecture guide for internal algorithms and data structures of Renew was added.<br />-Undo, redo, search, and replace commands were added.<br />-Autosave of Drawings.<br />-Arcs can be B-splines. Places and transitions can be refined.<br />-Specific alignment for each text figure.<br />-It is possible to merge nets and to coarsen subnets.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| Renew 1.5.1 | -Maintenance release that provided bug fixes for the simulation engine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| Renew 1.5.2 | -Maintenance release that provided bug fixes for the install scripts and a performance improvement of the simulation engine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| Renew 1.6   | -Renew requires Java 1.2 or higher now.<br />-Bug fixes in the Java net parser, class loader, and simulation engine.<br />-The Windows menu is alphabetically organized, and it is possible to de-iconify Windows.<br />-The serialization and rendering of the shadow net system have been improved.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | -A remote layer to separate the simulation and visualization processes.<br />-A dynamic net loader to load nets on demand.<br />-A new inscription manual can be attached to transitions that must not fire autonomously.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| Renew 2.0   | -Renew requires Java 1.4 or higher now.<br />-The Simulation engine was restructured.<br />-The :net() channel is no longer invoked implicitly on instance creation.<br />-The expanded token display feature as part of the optional fs plug-in.<br />-GUI application classes were restructured and converted to use the Swing package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | -Renew now has a plug-in architecture.<br />-Handling of the various configuration properties has been canonized by the plug-in system.<br />-On-the-fly switching of simulator modes, net formalisms, net loader path, and remote access feature was implemented.<br />- A PNML-compatible export format was added.<br />-The editor can load drawings from URLs.<br />-The net loader can now search nets relative to the classpath.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| Renew 2.0.1 | -Maintenance release that provided bug fixes for the install scripts and some redraw issues of the graphical net editor.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | -An experimental AppleUI plug-in as an option to download for a rudimentary integration with the macOS look and feel.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| Renew 2.1   | -Bug fixes throughout the code.<br />-The color and font attribute dialogs were improved.<br />-Whitespace-only inscriptions are now deleted automatically.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | -Except for the terminal prompt, all Renew components in this release include the Apache Log4J logging framework.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| Renew 2.1.1 | -Maintenance release that provided several minor bug fixes for PNML export, null token display, and access to public methods of private (inner) classes in Java expressions.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | -experimental AppleUI plug-in to build a MacOS X application bundle.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| Renew 2.2   | -All simulation-related code is now internally executed within specific threads.<br />-Renew requires Java 1.5 now.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | -This release introduced the FreeHep vector graphics package for screen presentation and to support additional export formats like PDF, PNG, and SVG.<br />-Improvements to attributes of drawing figures and to user interaction via mouse and keyboard were made.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| Renew 2.3   | -Renew requires at least Java 1.6.<br />-Bug fixes throughout the code.<br />-Switched to FreeHep Vector Graphics libraries version 2.2.<br />-The editor offers a better syntax check which proposes fields and methods in case your input does not match existing ones.<br />-The editor offers a better syntax check which proposes fields and methods in case your input does not match existing ones. <br />-usability enhancements.<br />-changed shortcut for net step to Ctrl-Shift-I                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | -List of recently saved drawings under 'File' menu.<br />-Navigator plug-in, allows fast access to Renew nets.<br />-Nice splashscreen on startup.<br />-Code streamlining, documentation, usage of generics.<br />-reenabled token display without white background (optional, requires setting the de.renew.gui.noTokenBackground property).<br />-new arrow tip "diamond".<br />-shortcut for new Navigator plug-in is Strg-Shift-N.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| Renew 2.4   | -The support for the .xrn format is discontinued. We encourage the use of PNML instead.<br />-Remote Server connection (RMI) was fixed by providing configuration.<br />-The simulation database backing was fixed, and the mechanism for MySQL / InnoDB was adapted.<br />-Remaining AWT dialogues have been converted to Swing.<br />-The Logging GUI has been improved by decoupling the simulator from the GUI.<br />-The loadrenew script now starts a regular Renew instance if the connection to a Drawing Load Server is not possible.<br />-The desktop integration for Linux and Windows has been improved.<br />-New unified icons for all operating systems were provided.<br />-Many minor bugs have been fixed                                                                                                                                                                                                                                     | -The Navigator now offers a button to recursively expand a directory sub-tree.<br />-The Navigator now loads directories without locking the GUI.<br />-PNML and ARM files are shown in the Navigator.<br />-The keyboard shortcut Ctrl+Enter closes the text editor overlay.<br />-The background transparency of EPS files can now be controlled by setting the property de.renew.io.export.eps-transparency.<br />-Windows: The installation script installrenew.bat creates reg files that associate and disassociate Renew drawing files with loadrenew.bat and register icons.<br />- Deb packages were provided for Debian-based systems.<br />- Large parts of the code base were refactored.<br />-Many Java compiler warnings have been resolved, and Javadoc documentation has been improved.<br />-A few more JUnit tests have been introduced.<br />-Logging and the simulator have been partially reworked to allow deadlock-free real-time (GUI) logging with only minimal time delay.<br />-Several tools that were originally mandatory to build Renew are now optional: these are Cobertura, Jalopy, JUnit, and Latex. |
| Renew 2.4.1 | -Maintenance release that provides a fix for a race condition that occurs under rare conditions during the termination of the simulation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| Renew 2.4.2 | -Maintenance release that provides a fix for the import of reference nets from PNML format (RefNet).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| Renew 2.4.3 | -Maintenance release that provides an update of the FreeHep library and a new version of the Mac OS X application bundle. It fixes issues concerning the export functionality with newer Java versions.<br />-Renew requires at least Java 7.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| Renew 2.5   | -Complete reimplementation of the Navigator plug-in.<br />-The FreeHEP library has been upgraded to version 2.4.<br />-The quick-draw feature has been improved.<br />-Some key-bindings are now configurable.<br />-The log4j configuration and the configuration GUI have been improved.<br />-The individual log4j configuration file now resides in the folder renew, which is located in the user's home folder. The default location for log files was moved there, as well.<br />-The loading of plug-ins at startup can now be black-listed or white-listed.<br />-The PDF export produces PDF documents with bounding boxes; configuration has been fixed.<br />-The grid can now be adapted, and it can be activated as the default.<br />-Several console commands have been improved.<br />-Macao format has been removed, since its usability was very limited.<br />-The PostScript export has been removed. Use EPS export or PDF export instead. | -The Console plug-in replaces the Prompt plug-in.<br />-Quick Fix feature improves the reporting of syntax errors by providing suitable proposals for remedies and their automatic realization.<br />-Refactoring plug-in provides features such as renaming of variables or renaming of synchronous channels.<br />-Drag & drop for drawings are available.<br />-Target text tool and comment tool have been added.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| Renew 2.5.1 | -Maintenance release that updates the Jline library, which fixes an error during start that prevented the start of Renew with some terminal emulators.<br />-Renew requires at least Java 11.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| Renew 2.6   | -The PNML export and import were reimplemented.<br />-The accidental overwriting of imported files in the wrong format is now prevented.<br />-Some keyboard shortcuts have been changed.<br />-The background for the PNG export is now transparent.<br />-Multiple smaller bug fixes and code improvements.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | -A zooming feature was provided.<br />-The automatic layout now provides a new option, Random, which uses a simulated annealing algorithm to control the parameters of the automatic layout automatically.<br />-Moving figures with the arrow keys now creates undo snapshots.<br />-The installrenew script additionally generates a renewexport script to export images from Renew drawing files.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| Renew 4.0   | -Changed Renew's architecture to the Java Platform Module System architecture, turning Renew's plug-ins into modules.<br />-Changed the build system from Apache Ant to Gradle.<br />-Reworked the whole user interface by combining the different windows into one.<br />-The toolbars are grouped on the left side of the window.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | -A new attribute bar in the upper right corner of every net allows faster changes to net elements.<br />-Added a zoom in, zoom out, and zoom reset button.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| Renew 4.1   | -                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | -Introducing a new formalism for P/T channels with synchronous channels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| Renew 4.2   | -Updated to Java 17.<br />-Improved the stability of all plugins.<br />-Some user experience improvements.<br /> -Resolved GUI-related issues.<br />-See Renew manual for full changelog.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | -Readded Lola2 plugin<br />-Added virtual transitions.<br />-Added a new Zoom Area Tool to zoom in on a selected area of a drawing.<br />-Added property management framework for multiple plugins. <br />-See Renew manual for full changelog.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |


### <a name="toc_6"></a>2.5 Known Bugs

This chapter shows an overview of some known bugs in Renew:

- Although the plug-in is terminated and all dependencies are cleaned using the unload command, its classes will still be accessible.
- Changes to the yellow handles of the elbow connection tool are not stored. Also, if the connected figures are close together, the decision whether to go horizontal or vertical first is relatively poor. Since no elbow connections are needed to construct reference nets, we do not care about these bugs.
- The editor is not able to display two net instances with the same name and ID. It will bring the existing net instance window to the front when the user selects a net instance with the same name and ID from a different simulation. To see the other net instance, close the existing net instance window.
- The mouse actions to inspect a trace entry are not available before you have selected any line of the simulation step it belongs to.
- The Console-Plugin does not work correctly when using Git Bash on Windows. If it is intended to be used, enter zZ: -Djline.terminal=jline.UnixTerminal as a parameter when starting Renew via the Git Bash.
- using == or != to compare the equality of strings, like in s1==s2 would provide strange results. Use the Java-method equals(...) as in s1.equals(s2).
- The current implementation of flexible arcs shows inconsistent behavior when the arc expression does not evaluate to an array or collection object. In such cases, flexible output arcs fall back to shove the unmodified token into the output place, while flexible input arcs do not activate the transition.
- The Encapsulated PostScript output does not support transparent GIF images, but some other export formats (e.g., PDF and SVG) do.
- If the Renew GUI is closed and the Navigator was opened beforehand, Renew might still be running.
- The shortcut works only on an English keyboard layout, where the keys for the shortcut can be typed directly, i.e., without additional modifiers like Shift.
- The attribute buttons in the upper right corner can act weird sometimes.
- The transparency attribute is ignored in EPS export. However, transparencies are printed correctly using the Print dialogue and in the PDF, SVG, and PNG export formats.
- There are situations where a net invokes a Java method that does not terminate. In these cases, Renew cannot halt the simulation.


## <a name="toc_7"></a>3. Developer Guide


### <a name="toc_8"></a>3.1 Installing and Building Renew for Developers

First of all, you must have at least Java 17 (Warning: Renew may fail to build on some higher Java versions) installed, because the Java Runtime Environment (JRE) is needed to use Renew. You also need JDK (Java Development Kit) version 17 (Warning: Renew may fail to build on some higher JDK versions) (https://adoptopenjdk.net/). Furthermore, you need to add Java to the path environment variable and set the JAVA_HOME variable.

Second, you need to download the source package from http://www.renew.de/
Since Release 4.0 and changing the build system to Gradle, we have to distinguish between installing and building from the source package with Ant (install Renew 2.6) and with Gradle (install Renew 4.2).

**Install Renew 2.6 from source package:**

You need additional libraries that are not included in the distribution.
- The Apache Ant build tool
- The parser generator JavaCC
- An IDE (Eclipse is used as a code formatter)

Then, you need to add the installed Ant to the path, check if Ant works (run: `ant -version`), and check if the dist folder exists(run: `ant clean dist`). If the build is successful, this will generate the folders `dist` and `dist/plugins`. You should now be able to run Renew by navigating to the folder `dist` and opening the bash/cmd, then running `java -jar loader.jar gui`.

For details, see: https://www.informatik.uni-hamburg.de/TGI/renew/2.6/install.html

**Install Renew 4.2 from source package:**

Since we are working on/with Gradle, it will automatically take care of all dependencies. You do not even need Gradle installed, as the source package comes with its own Gradle wrapper.

run`./gradlew dist`(Unix) or `gradlew dist`(Win) in the source folder. If the build is successful, this will generate the folders `dist` and `dist/plugins`. You should now be able to run Renew with: `java -p dist:dist/libs -m de.renew.loader gui` (this is the case for Linux and Mac, please note the use of `dist:dist;` for Windows, it is `dist;dist`, and for git bash, you use `dist\;dist` as well as `dist\;dist/libs` for Windows PowerShell) and start working.

For details, see: https://www.informatik.uni-hamburg.de/TGI/renew/4.2/install.html


### <a name="toc_9"></a>3.2 Code Style

- Renew uses Java 17 libraries.
- All files are encoded using UTF-8.
- Imports: separately (no *) and in alphabetical order.
- No tabs (just use spaces, four spaces equals one tab).
- Essentially, the style information is in the formatter rules:
  - Jalopy formatter was used for a while, but that is no longer maintained and does not support newer language constructs, see `renew2.6\src\ant\jalopy-pref.xml`
  - Therefore, the Eclipse formatter was used.
  - After release 4.0 and changing the build system to Gradle, Spotless was used for automatic Java Code Formatting, which also supports the Eclipse formatter.

**Naming**

| Type                     | Convention                                  | Example           |
|--------------------------|---------------------------------------------|-------------------|
| Package names	           | Lowercase + no word separation	             | de.renew.plugin   |
| Class names	             | UpperCamelCase	                             | ClassName         |
| Method names	            | LowerCamelCase	                             | methodName        |
| Constant names	          | Uppercase + underscore for word separation	 | CONSTANT_NAME     |
| Non-constant field names | LowerCamelCase + underscore as prefix	      | _nonConstantField |
| Parameter names	         | LowerCamelCase                              | parameterName     |
| Local variable names	    | LowerCamelCase                              | localVariableName |

**Code Documentation**

| Type      | Header | Javadoc-Tags (mandatory) | Javadoc-Tags (mandatory) |
|-----------|--------|--------------------------|--------------------------|
| Module    | +      |                          | @author, @version        |
| Class     | +      |                          | @author, @version        |
| Interface | +      |                          | @author, @version        |
| Method    | +      | @param, @return	         | @author                  |
- The documentation of methods is only necessary if the access modifier is not private.

- Do not use the Javadoc tag `@see` for the link, but `@link`.


### <a name="toc_10"></a>3.3 Used Tools


| Name                        | Version                          | Purpose                                                                                    | URL                                                                       | Needed for                                     |
|-----------------------------|----------------------------------|--------------------------------------------------------------------------------------------|---------------------------------------------------------------------------|------------------------------------------------|  
| Ant                         | 1.10.8                           | Managing the build process                                                                 | https://ant.apache.org/	                                                  |                                                |    
| Antlr                       | 2.7.7	                           | Parser generation 	                                                                        | https://www.antlr.org/                                                    |                                                |   
| Antlr-runtime               | 3.5.2	                           | 	                                                                                          | https://www.antlr.org/                                                    |                                                |
| Antlr4                      | 4.8	                             | Parser generation 	                                                                        | https://www.antlr.org/                                                    |                                                |
| Antlr4-runtime              | 4.8	                             | 	                                                                                          | https://www.antlr.org/                                                    |                                                |
| AppBundler                  | 1.0ea	                           | Bundle the JAR File into an App Package                                                    |                                                                           | Ant task to create MacOS X application bundles |    
| Abego TreeLayout Core       | 1.0.3	                           | Efficient and customizable TreeLayout Algorithm in Java  	                                 |                                                                           |                                                |
| Assertj                     | 3.20.2	                          | Writing assertions                                                                         |                                                                           | Testing                                        |    
| Aspectjweaver               | 1.9.6	                           |                                                                                            |                                                                           | Cloudnative spring                             |
| Activation                  | 1.1                              | Used by the JavaMail(TM) API to manage MIME data	 	                                        | https://www.oracle.com/java/technologies/java-beans-activation.html       | MailMotificationNetComponents plugin           |    
| BCEL                        | 6.0                              | Byte Code Engineering Library	 	                                                           | https://commons.apache.org/proper/commons-bcel/                           |                                                |    
| Blockhound                  | 1.0.6	                           |                                                                                            |                                                                           | Cloudnative spring                             |
| Bouncyastle                 | 1.68                             | Complements the default Java Cryptographic Extension                                       | https://www.bouncycastle.org/                                             |                                                |    
| Byte buddy                  | 1.11.0	                          | Runtime code generation for the JVM.                                                       |                                                                           | Cloudnative spring                             |
| Byte buddy agent            | 1.10.19	                         |                                                                                            |                                                                           | Cloudnative spring                             |
| Commons cli                 | 1.3                              | Simple API for presenting, processing, and validating a Command Line Interface.            | https://commons.apache.org/proper/commons-cli/                            |                                                |    
| Commons io                  | 2.5	                             | to assist with developing IO functionality                                                 | https://commons.apache.org/proper/commons-io/                             |                                                |
| Commons lang3               | 3.11	                            | to provide enough methods for manipulation of its core classes                             | https://commons.apache.org/proper/commons-lang/                           |                                                |
| Collections                 | 	                                |                                                                                            |                                                                           | Feature structures plugin                      |
| CDI Api                     | 1.2	                             | APIs for CDI (Contexts and Dependency Injection for Java)                                  |                                                                           |                                                |
| Classgraph                  | 4.8.102	                         |                                                                                            |                                                                           |                                                |
| Classmate                   | 1.5.1	                           |                                                                                            |                                                                           |                                                |
| Darcula                     | 	                                | Theme for code editors	 	                                                                  | https://draculatheme.com/                                                 |                                                |    
| Db4o                        | 8.0.184.15484-all-java5          | Database for objects	 	 	                                                                  | https://dbdb.io/db/db4o                                                   |                                                |    
| Dockingframes               | 	                                | Java Swing docking framework  	                                                            | https://www.docking-frames.org/                                           |                                                |    
| Eclipse.jgit	               | 2.1.0.2012091902330-r            | Repository access and algorithms	 	 	                                                      | https://www.eclipse.org/jgit/                                             | JGit                                           |    
| freehep                     | io.2.3 & graphicsio-ps-2.4-renew | Encourage the sharing and reuse of Java code in High Energy Physics                        | https://java.freehep.org/                                                 |                                                |    
| Gradle                      | 7.3.3                            | Managing the build process	 	                                                              | https://gradle.org/                                                       |                                                |    
| Greenmail                   | 1.6.0                            | Testing email servers	 	                                                                   | https://github.com/greenmail-mail-test/greenmail	 	                       | Testing MailMotificationNetComponents plugin   |    
| Gitective                   | 0.9.9                            | Investigating Git repositories, support finding commits	  	                                | https://mvnrepository.com/artifact/org.gitective/gitective-core/0.9.9	  	 | JGit                                           |    
| Guava                       | 10.0.1                           | Google Core Libraries for Java                                                             | https://github.com/google/guava                                           |                                                |    
| H2                          | 1.4.200	                         | 	Database egin	                                                                            | http://www.h2database.com/html/download.html                              |                                                |
| HdrHistogram                | 2.1.12	                          | recording histograms of value                                                              | 	http://hdrhistogram.org/	                                                |                                                |
| Hsqldb                      |                                  | Relational database management system	 	                                                   | https://hsqldb.org/	 	                                                    |                                                |    
| Hamcrest                    | 1.3                              | Assists writing tests                                                                      | https://hamcrest.org/JavaHamcrest/	  	                                    | Unit testing                                   |    
| Hibernate commons           | 5.1.2	                           | 	style annotations for Hibernate	                                                          | http://www.h2database.com/html/download.html                              |                                                |
| Hibernate core              | 5.4.27	                          |                                                                                            |                                                                           |                                                |
| HikariCP                    | 3.4.5	                           | 	solid high-performance JDBC connection pool	                                              |                                                                           | Cloudnative spring                             |
| Istack common runtime       | 3.0.11	                          |                                                                                            |                                                                           |                                                |
| Icu4j                       | 61.1	                            | 	International Component for Unicode for Java	                                             |                                                                           |                                                |
| Java-JDK                    | 17                               | Code compilation                                                                           | https://www.oracle.com/java/technologies/downloads/	 	                    |                                                |    
| Javacc	                     | 3.0.3                            | Parser generation                                                                          | 	                                                                         | https://javacc.github.io/javacc/	              |    
| Javax.json                  | 1.0.4	                           |                                                                                            |                                                                           |                                                |
| Javax.inject                | 1	                               |                                                                                            |                                                                           |                                                |
| Javax.interceptor-api       | 1.2	                             |                                                                                            |                                                                           |                                                |
| Jaxb runtime                | 2.3.3	                           | Provides an API and tools that automate the mapping between XML documents and Java objects |                                                                           |                                                |
| Jgraph-5                    | 13.0.0	                          |                                                                                            |                                                                           |                                                |
| Jgtapht coret               | 0.9.2	                           |                                                                                            | https://jgrapht.org/                                                      |                                                |
| Jgtaphx                     | 2.0.0.1	                         | 	Java Swing diagramming	                                                                   | https://jgraph.github.io/mxgraph/docs/manual_javavis.html                 |                                                |
| Jfiglet                     | 1.0-alpha1	                      |                                                                                            |                                                                           |                                                |
| Jline                       | 2.14.4                           | Handling console input	  	                                                                 | https://github.com/jline/jline2	 	                                        |                                                |    
| JUnit	                      | 4.13 & 5                         | Testing framework for Java                                                                 | https://junit.org/junit5/	 	                                              | Testing                                        |
| Javax.mail	                 | 1.6.2                            | Build mail and messaging system	  	                                                        | https://javaee.github.io/javamail/                                        | MailMotificationNetComponents plugin           |    
| Jackson*                    | 2.11.4	                          |                                                                                            |                                                                           |                                                |
| Jakarta*                    | 	                                |                                                                                            |                                                                           |                                                |
| Jandex                      | 2.1.3 	                          |                                                                                            |                                                                           |                                                |
| Javassist                   | 3.27.0  	                        | Java Programming Assistant                                                                 | https://www.javassist.org/                                                |                                                |
| Jsch-0                      | 1.44 	                           | Java Secure Channel                                                                        | 	http://www.jcraft.com/jsch/	                                             | To connect to an sshd server                   |
| Kafka clients               | 2.6.0 	                          |                                                                                            | 	https://kafka.apache.org/documentation/	                                 |                                                |
| Log4j                       | 1.2.12                           | Logging Management	   	                                                                    | https://logging.apache.org/log4j/1.2/index.html	  	                       |                                                |    
| Log4j api                   | 2.18.0  	                        |                                                                                            |                                                                           |                                                |
| Log4j to slf4j              | 2.18.0 	                         |                                                                                            |                                                                           |                                                |
| Jul-to-slf4j                | 1.7.30 	                         | Translates LogRecord objects into their SLF4J equivalent                                   | https://www.slf4j.org/legacy.html                                         |                                                |
| Jboss-logging               | 3.4.1 	                          | Create internationalized log statements and exceptions                                     |                                                                           |                                                |
| Logback classic             | 1.2.3  	                         |                                                                                            | https://logback.qos.ch/                                                   | for Logging                                    |
| Logback core                | 1.2.3  	                         |                                                                                            | https://logback.qos.ch/                                                   | for Logging                                    |
| LatencyUtils                | 2.0.3	                           |                                                                                            |                                                                           |                                                |
| Lz4 java                    | 1.7.1	                           |                                                                                            |                                                                           |                                                |
| Lombok                      | 1.18.20                          | Automatically plugs into editor and build tools, spicing up Java.                          | https://projectlombok.org/	 	                                             | Momoc plugin                                   |    
| Mockito                     | 1.9.5 & 3.12.1                   | Mockup framework for Java                                                                  | https://github.com/mockito/mockito                                        | Testing                                        |    
| Micrometer core             | 1.6.3 	                          |                                                                                            |                                                                           |                                                |
| StringTemplate4 (ST4)       | 4.3	                             | Java template engine for generating source code                                            |                                                                           | various logging frameworks                     |
| Slf4j api                   | 1.7.30	                          | Simple Logging Facade for Java                                                             | https://www.slf4j.org/                                                    |                                                |
| Snakeyaml                   | 1.27 	                           |                                                                                            |                                                                           |                                                |
| Snappy java                 | 1.1.7.3  	                       |                                                                                            |                                                                           |                                                |
| Spring*                     | 5.3.3  	                         |                                                                                            |                                                                           |                                                |
| Spring boot*                | 2.4.2 	                          |                                                                                            |                                                                           |                                                |
| Springdoc*                  | 1.5.4 	                          |                                                                                            |                                                                           |                                                |
| Swagger*                    | 2.1.6 	                          |                                                                                            |                                                                           |                                                |
| Tomcat embed core/ websockt | 9.0.41 	                         |                                                                                            |                                                                           |                                                |
| Txw2                        | 2.3.3	                           |                                                                                            |                                                                           |                                                |
| Ujmp	                       | 0.3.0                            | Universal Java Matrix Package                                                              | https://ujmp.org/                                                         |                                                |    
| Velocity                    | 1.7                              | Template engine	 	                                                                         | https://velocity.apache.org/engine/1.7/overview.html                      |                                                |
| Velocity tools generic      | 2.0 	                            |                                                                                            | https://velocity.apache.org/tools/3.1/generic.html                        |                                                |
| Webjars locator websocket   | 0.46 	                           |                                                                                            |                                                                           |                                                |
| Zstd jni                    | 1.4.4-7 	                        |                                                                                            |                                                                           |                                                |


## <a name="toc_11"></a>4. Additional Information

### <a name="toc_12"></a>4.1 Gradle

It is a *Groovy*-based build management system designed specifically for building Java-based projects.

A project using Gradle describes its build via a *build.gradle* file. This file is located in the root folder of the project and collaborates with the *settings.gradle* file which declares all projects used in this build.

A *build.gradle* file consists of one or more *tasks* which represent a single piece of work and contain declarative and imperative statements. Each *task* has a name, which can be used to refer to the task within its owning project, and a fully qualified path, which is unique across all tasks in all projects.
The path is the concatenation of the owning project's path and the *task*'s name. Path elements are separated using the *: character*. As a result, a **Gradle** project produces artifacts like .jar, .war, or even .zip files.

The Gradle **wrapper** builds the project with a predefined version and settings of **Gradle** without a local **Gradle** installation. The *wrapper* is triggered by the *gradlew.bat* on Windows or a *gradlew* script for other operating systems.
When a **Gradle** build gets triggered via the *wrapper*, the specified version of **Gradle** is automatically downloaded and used to run the build.

#### <a name="toc_13"></a>4.1.1 Example Gradle Tasks

- **./gradlew --all** to show task list with task descriptions
- **./gradlew renew** to build renew with all plug-ins
- **./gradlew clean** to clean the project's dist folders
- **./gradlew cleanModules** to clean all created renew plug-ins
- **./gradlew :PLUGINNAME:test** to run tests
- **./gradlew :Util:jar** to build only the util project
- **./gradlew :PLUGINNAME:javadoc** to generate javadoc files
- Spotless
  - **gradlew spotless --check** to check style guide
  - **gradlew spotless --apply** to fix flaws
- Eclipse
  - **gradlew eclipse**  to generate the Eclipse project information
  - **gradlew cleanEclipse**	to delete the Eclipse project information


### <a name="toc_14"></a>4.2 Contribution Info

For details, see: https://www.informatik.uni-hamburg.de/TGI/renew/contributors.html

- Theoretical Foundations Group and Distributed Systems Group (Department for Informatics, University of Hamburg)
- Lawrence Cabac
- Michael Duvigneau
- Michael Haustermann
- Olaf Kummer
- David Mosteller
- Frank Wienberg
- And many others who helped to develop Renew and to reach its current state.
- The students who helped with the development and release of Renew 2.6 and the following releases,
  - See the Renew manual for a list of contributors to the Renew project.


For details, see: https://www.informatik.uni-hamburg.de/TGI/renew/contributors.html


### <a name="toc_15"></a>4.3 License

For details, see: https://www.informatik.uni-hamburg.de/TGI/renew/license.html

Short version:

- Renew is available free of charge
- Any work you create using Renew is your own and is not subject to any restrictions from Renew
- The authors of Renew are not liable for any (!) kind of damages that may occur through the use of Renew

Some parts of it are original (by the authors of Renew)

- Example nets can be modified/used as a basis for your own nets
- Java Source Code and Executables are copyrighted
  Other parts were previously published by other people (some of these may not be free everywhere):

- Code generated by JavaCC (parser generator)
- Java grammar billsJava1.0.2.jj by Bill McKeeman
- Graph Layout Algorithm in de.renew.gui.GraphLayout
- Collections package by Doug Lea (use container libraries in Java 1.2)
- JHotDraw graphical editor by Erich Gamma
- Log4j package from the Apache Logging Services project
- FreeHEP VectorGraphics package by the FreeHEP project
- JLine2 classes
- Commons CLI library from the Apache project
- DockingFrames framework
- Gradle Wrapper script from Apache