package de.renew.refactoring.parse;

import de.renew.expression.Expression;
import de.renew.net.inscription.transition.DownlinkInscription;
import de.renew.net.inscription.transition.UplinkInscription;


/**
 * Abstraction for {@link UplinkInscription} and {@link DownlinkInscription}
 * that responds to their common fields.
 *
 * @author 2mfriedr
 */
public class LinkInscription {
    private UplinkInscription _uplinkInscription;
    private DownlinkInscription _downlinkInscription;

    public LinkInscription(Object inscription) throws IllegalArgumentException {
        if (inscription instanceof UplinkInscription) {
            _uplinkInscription = (UplinkInscription) inscription;
        } else if (inscription instanceof DownlinkInscription) {
            _downlinkInscription = (DownlinkInscription) inscription;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public Object getObject() {
        return isUplink() ? _uplinkInscription : _downlinkInscription;
    }

    public String getName() {
        return isUplink() ? _uplinkInscription.getName() : _downlinkInscription.getName();
    }

    public int getBeginLine() {
        return isUplink() ? _uplinkInscription.getUplinkBeginLine()
            : _downlinkInscription.getDownlinkBeginLine();
    }

    public int getBeginColumn() {
        return isUplink() ? _uplinkInscription.getUplinkBeginColumn()
            : _downlinkInscription.getDownlinkBeginColumn();
    }

    public int getEndLine() {
        return isUplink() ? _uplinkInscription.getUplinkEndLine()
            : _downlinkInscription.getDownlinkEndLine();
    }

    public int getEndColumn() {
        return isUplink() ? _uplinkInscription.getUplinkEndColumn()
            : _downlinkInscription.getDownlinkEndColumn();
    }

    public int getNameBeginLine() {
        return isUplink() ? _uplinkInscription.getNameBeginLine()
            : _downlinkInscription.getNameBeginLine();
    }

    public int getNameBeginColumn() {
        return isUplink() ? _uplinkInscription.getNameBeginColumn()
            : _downlinkInscription.getNameBeginColumn();
    }

    public int getNameEndLine() {
        return isUplink() ? _uplinkInscription.getNameEndLine()
            : _downlinkInscription.getNameEndLine();
    }

    public int getNameEndColumn() {
        return isUplink() ? _uplinkInscription.getNameEndColumn()
            : _downlinkInscription.getNameEndColumn();
    }

    public Expression getParams() {
        return isUplink() ? _uplinkInscription.getParams()
            : _downlinkInscription.getParameterExpression();
    }

    private boolean isUplink() {
        return _uplinkInscription != null;
    }
}