package de.renew.refactoring.renamevariable;

import java.util.List;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNDrawingView;
import de.renew.refactoring.inline.SingleInlineUndoableCommand;
import de.renew.refactoring.parse.DeclarationFinder;
import de.renew.refactoring.parse.JNPVariableParser;


/**
 * Command for the refactoring Rename Variable.
 *
 * @author 2mfriedr
 */
public class RenameVariableCommand extends SingleInlineUndoableCommand {
    private static final org.apache.log4j.Logger LOGGER =
        org.apache.log4j.Logger.getLogger(RenameVariableCommand.class);
    private static final String COMMAND_NAME = "Rename variable...";

    public RenameVariableCommand() {
        super(COMMAND_NAME);
    }

    @Override
    protected boolean executeUndoable() {
        Drawing drawing = getEditor().drawing();
        String declaration = new DeclarationFinder(drawing).declarationText();
        CPNDrawingView drawingView = (CPNDrawingView) getEditor().view();
        try {
            RenameVariableInlineController controller =
                new RenameVariableInlineController(new JNPVariableParser(declaration), drawingView);
            setInline(controller);
        } catch (NoVariableSelectedException e) {
            getEditor().showStatus("There is a syntax error or no variable is selected.");
            return false;
        }

        return true;
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }

        Drawing drawing = getEditor().drawing();
        if (!(drawing instanceof CPNDrawing)) {
            return false;
        }

        List<Figure> selection = getEditor().view().selection();

        // The refactoring is marked as executable if
        // a) a single text figure is selected
        RenameVariableSelectionChecker selChecker =
            new RenameVariableSelectionChecker(selection, null);
        if (selChecker.isTextFigureSelected()) {
            return true;
        }

        DeclarationFinder declFinder = new DeclarationFinder(drawing);

        // or b) the drawing has a declaration figure
        return declFinder.hasDeclarationFigure();
    }
}