# Remote
The Remote Plugin is used to allow the Remote Method Invocation for Renew net instances.

### Features
- Configures the simulation engine for remote access
- Connects to a running remote simulation

### Example Usage
1. Start an RMI registry on the machine where the server will be running.
2. Set the property de.renew.remote.enable to true.
3. Start Renew
4. Start a simulation
5. On another machine:
   1. Start Renew
   2. Simulation-> Remote Server -> Connect
   3. Specify the host on which the server is running and the Name (which can be left at the default value unless you specified the de.renew.remote.publicName
      property on the server side)
   4. Upon clicking Connect the remote simulation should now be selectable in the drop-down box
   5. Select and open nets from the server in the net instance window. All modifications are executed on the server.
   6. Terminate the remote connection by clicking Disconnect or quitting Renew

### Provided Commands
Remote doesn't provide any commands.

### Installation
Install _Remote_ by putting the JAR file inside the dist/plugins directory. It will be automatically loaded at startup of Renew - see below for more configuration options.

### Dependencies
- `Simulator` : Simulation engine

### Configuration
During the initialization of _Remote_ the following properties are read from the `renew.properties` file in the Renew root directory.

**NAME**|**TYPE**|**DESCRIPTION**|**DEFAULT**
:-----|:-----:|:-----|:-----
`de.renew.remote.enable`|boolean|Enables remote access|false
`de.renew.remote.publicName`| String | Name to use for RMI registration| default
`de.renew.remote.serverClass`| class | Implementation of the interface de.renew.remote.Server . | de.renew.remote.ServerImpl
`de.renew.remote.socketFactory` | class | Implementation of the interface java.rmi.server.RMISocketFactory. | RMI's default factory
`de.renew.remote.rmi-host-name`| String | The rmi server hostname to the cor- rect ip if the remote server cannot be found. It is similar to the java property java.rmi.server.hostname | (not set)
## Developer Guide

### Core Classes
- 'RemotePlugin': Extends `PluginAdapter` which implements the `IPlugin` interface to manage startup and shutdown.
- 'BindingAccessor': wraps bindings to provide the functionality to list and fire bindings from the client.
- 'TriggerableForwarder': represents an object that receives search proposals from the simulator and passes them to a client object that does not want to expose itself as remote object

### How to Extend
Remote exposes multiple Interfaces:
- `de.renew.remote.AggregateAccessor` - an aggregate accessor can be wrapped around a `de.renew.unify.Aggregate` token, allowing the inspection of it's contents
- `de.renew.remote.BindingAccessor` - the binding accessor wraps bindings to provide the functionality to list and fire bindings from the client
- `de.renew.remote.EventListener` - this interface allows the receipt of not-really-local update events
- `de.renew.remote.MarkingAccessor` - represents the marking of a place instance as a snapshot
- `de.renew.remote.NetAccessor` - a net accessor allows to create accessors for the places and transitions of a net
- `de.renew.remote.NetInstanceAccessor` - a net instance accessor allows to create accessors for the place and transition instances of a net instance
- `de.renew.remote.ObjectAccessor` - an object accessor allows to view some attributes of its associated object
- `de.renew.remote.PlaceAccessor` - a place accessor allows to view and modify the state of a place
- `de.renew.remote.PlaceInstanceAccessor` - a place instance accessor allows to view and modify the state of a place instance
- `de.renew.remote.RemoteEventListener` - this interface allows the receipt of remote events
- `de.renew.remote.RemoteEventProducer` - the producer interface for managing remote event listeners
- `de.renew.remote.RemoteObjectHelperObserver` - interface for classes the wish to observe changes in a RemoteObjectHelper
- `de.renew.remote.RemoteServerRegistryListener` - allows to listen at the `RemoteServerRegistry` for addition and removal of server entries
- `de.renew.remote.RemoteTriggerable` - a remote triggerable is a client object that gets the search proposals forwarded from the triggerable forwarder
- `de.renew.remote.Server` - use this class to access net instances and other simulation elements remotely
- `de.renew.remote.SimulatorAccessor` - a simulator accessor allows an application to control a remote simulator by starting and stopping the search process
- `de.renew.remote.TextTokenAccessor` - a text token accessor can be wrapped around a `de.renew.util.TextToken` implementation, allowing the retrieval of its textual representation
- `de.renew.remote.TokenCountsAccessor` - provides access to the token counts of a place instance
- `de.renew.remote.TransitionAccessor` - a transition accessor allows to view and modify the state of a transition
- `de.renew.remote.TransitionInstanceAccessor` - a transition instance accessor allows to view and modify the state of a transition instance
- `de.renew.remote.TriggerableForwarder` - the triggerable forwarder represents an object that receives search proposals from the simulator and passes them to a client object that does not want to expose itself as remote object

You can implement those interfaces to add additional functionality to Remote.
### Additional Information

The 'Secure RMI with Cryptix' package provides an example implementation
for secure remote simulations with Renew. It can be found in the 'resources' directory.