package de.renew.remote;

import java.rmi.RemoteException;

import de.renew.simulatorontology.simulation.SimulationEnvironment;
import de.renew.util.TextToken;


/**
 * This class implements the <code>TextTokenAccessor</code>
 * interface and nothing more.
 * TextTokenAccessorImpl.java
 * Created: Tue Oct 7  2003
 * @author Michael Duvigneau
 * @since Renew 2.0
 */
public class TextTokenAccessorImpl extends ObjectAccessorImpl implements TextTokenAccessor {

    /**
     * The wrapped object, still typed as <code>TextToken</code>.
     **/
    private TextToken _textToken;

    /**
     * Creates a new accessor for the given text token.
     *
     * @param textToken    the text token for the accessor.
     *
     * @param environment  the simulation environment where this
     *                     object belongs to.
     *
     * @exception RemoteException
     *   if a RMI failure occured.
     **/
    public TextTokenAccessorImpl(TextToken textToken, SimulationEnvironment environment)
        throws RemoteException
    {
        super(textToken, environment);
        this._textToken = textToken;
    }

    /**
     * @see TextTokenAccessor#toTokenText()
     **/
    @Override
    public String toTokenText() throws RemoteException {
        return _textToken.toTokenText();
    }
}