/**
 * Module `de.renew.remote` defines the public API and dependencies
 * for remote communication facilities within the Renew simulation environment.
 *
 * This module exports the `de.renew.remote` package, which provides classes and interfaces
 * for handling remote interactions and communication between distributed components.
 *
 * Dependencies:
 * - Requires the `de.renew.simulator` module transitively, as it utilizes simulation-related functionality.
 * - Requires the `java.rmi` module for Java Remote Method Invocation (RMI) capabilities.
 * - Requires the `ch.qos.reload4j` library for logging support using the reload4j framework.
 */
module de.renew.remote {
    // Provided Packages
    exports de.renew.remote;

    //Renew Dependencies
    requires de.renew.simulator.api;
    requires transitive de.renew.simulator.impl;
    requires transitive de.renew.simulatorontology;

    //Java Dependencies
    requires java.rmi;

    // Third-Party Dependencies
    requires ch.qos.reload4j;
}