package de.renew.remote;

import java.rmi.RemoteException;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

/**
 * Test class for {@link ServerImpl}.
 */
public class ServerImplTest extends Assertions {

    private static final String HOSTNAME = "www.uni-hamburg.de";
    private static final String SERVER_NAME = "myserver";

    @Test
    public void testMakeServerUrl() throws RemoteException {
        // given
        String serverUrl = ServerImpl.makeServerUrl(HOSTNAME, SERVER_NAME);
        // when/then
        assertThat(serverUrl).isEqualTo("//www.uni-hamburg.de/de.renew.remote.Server.myserver");
    }

    @Test
    public void testMakeLocalServerUrl() throws RemoteException {
        // given
        String serverUrl = ServerImpl.makeLocalServerUrl(SERVER_NAME);
        // when/then
        assertThat(serverUrl).isEqualTo("//localhost/de.renew.remote.Server.myserver");
    }

    @Test
    void testMakeServerUrlWithHostnameOnlyReturnsDefaultUrl() {
        // given
        String serverUrl = ServerImpl.makeServerUrl(HOSTNAME);
        // when/then
        assertThat(serverUrl).isEqualTo("//www.uni-hamburg.de/de.renew.remote.Server.default");
    }
}
