package de.renew.simulator.api;

import java.util.Collection;

import de.renew.simulatorontology.simulation.SimulatorExtension;

/**
 * Interface for storing the registered extensions of the simulator plugin.
 **/
public interface ISimulatorExtensions {
    /**
     * Registers an extension to the simulation component. The extension will
     * become active the next time a new simulation environment is set up.
     * Active extensions will be notified about several events (see
     * {@link SimulatorExtension} interface).
     *
     * @param extension the extension to register. Duplicate registrations will be
     *        ignored.
     */
    void addExtension(SimulatorExtension extension);

    /**
     * Removes and deregisters the given {@code SimulatorExtension} from the simulation engine.
     * The deregistration does not cancel active extensions from any currently running simulation,
     * but they will not be activated again when the next simulation is set up.
     *
     * @param extension the extension to deregister. If the extension was not
     *        registered before, this method call is ignored.s
     */
    void removeExtension(SimulatorExtension extension);

    /**
     * Getter for the currently registered extensions.
     * @return collection of currently registered extensions
     */
    Collection<SimulatorExtension> getSimulationExtensions();

    /**
     * Removes all registered extensions.
     */
    void cleanup();
}
