package de.renew.application;

import de.renew.api.ISimulationStateLoader;
import de.renew.simulator.api.ISimulationManager;

/**
 * This class provides an implementation of {@link ISimulationStateLoader}.
 */
public final class SimulationStateLoaderProvider {

    /**
     * Private, as no instances of this class should exist.
     */
    private SimulationStateLoaderProvider() {}

    /**
     * The provider method used by the {@link java.util.ServiceLoader}.
     *
     * @return an instance of {@code ISimulationStateLoader}
     */
    public static ISimulationStateLoader provider() {
        ISimulationManager simulationManager = SimulationManagerProvider.provider();
        return new SimulationStateLoader(simulationManager);
    }
}
