package de.renew.application;

import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

import org.apache.log4j.Logger;

import de.renew.simulator.api.ISimulatorExtensions;
import de.renew.simulatorontology.simulation.SimulatorExtension;

/**
 * Implementation class for {@link ISimulatorExtensions}.
 * It is provided to the interface module through the {@link SimulatorExtensionsProvider}.
 * The facade for this class is {@link de.renew.simulator.api.SimulatorExtensions}.
 */
class SimulatorExtensionsImpl implements ISimulatorExtensions {
    /**
     * The logger for this class.
     */
    private static final Logger LOGGER = Logger.getLogger(SimulatorExtensionsImpl.class);

    /**
     * Holds the set of all {@link SimulatorExtension} objects currently
     * registered with this plugin. Can be modified by {@link #addExtension} and
     * {@link #removeExtension}.
     */
    private final Queue<SimulatorExtension> _extensions = new ConcurrentLinkedQueue<>();

    @Override
    public void addExtension(SimulatorExtension extension) {
        LOGGER.debug("SimulatorExtensions: Registering extension " + extension + ".");
        _extensions.add(extension);
    }

    @Override
    public void removeExtension(SimulatorExtension extension) {
        LOGGER.debug("SimulatorExtensions: Deregistering extension " + extension + ".");
        _extensions.remove(extension);
    }

    @Override
    public Collection<SimulatorExtension> getSimulationExtensions() {
        return Collections.unmodifiableCollection(_extensions);
    }

    @Override
    public void cleanup() {
        _extensions.clear();
    }
}
