/*
 * Created on 19.10.2004
 */

package de.renew.engine.events;

import de.renew.net.PlaceInstance;


/**
 * Checks if a selected token is in the given {@link PlaceInstance}.
 *
 * @author Sven Offermann
 */
public class Checking extends PlaceEvent {
    private final Object _token;

    /**
     * Creates a new Checking event for a given token
     * and place instance.
     *
     * @param token the given value for the token
     * @param placeInstance the given {@link PlaceInstance} for the initialization of the {@link PlaceEvent}
     */
    public Checking(Object token, PlaceInstance placeInstance) {
        super(placeInstance);

        _token = token;
    }

    @Override
    public String toString() {
        return "Checking " + _token + " in " + getPlaceInstance();
    }

    /**
     * Returns the token that is checked in the place.
     *
     * @return the token
     */
    public Object getToken() {
        return _token;
    }
}