/*
 * Created on Nov 19, 2004
 *
 */

package de.renew.engine.events;

import de.renew.engine.thread.SimulationThreadPool;


/**
 * Notifies the user of trace messages.
 *
 * @author Sven Offerman
 */
public class TraceEvent implements SimulationEvent {
    private final String _traceMessage;

    /**
     * Initializes a {@link TraceEvent} with a given trace message.
     *
     * @param traceMessage the given trace message
     */
    public TraceEvent(String traceMessage) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        _traceMessage = traceMessage;
    }

    @Override
    public String toString() {
        return _traceMessage;
    }
}