package de.renew.engine.searcher;

/**
 * Binds searchers by looping through all the possible bindings
 * and gives roughly their count to test.
 */
public interface Binder {

    /**
     * Returns roughly the number of possible bindings to test.
     * Sometimes the searcher parameter ought to be
     * removed. It is unnecessary.
     *
     * @param searcher the current <code>Searcher</code>
     * @return roughly the number of possible bindings to test
     */
    int bindingBadness(Searcher searcher);

    /**
     * Loop through all the possible bindings: <ul>
     * <li>  register triggers, if required,   </li>
     * <li>  add other binders if required,    </li>
     * <li>  bind variables,                   </li>
     * <li>  call the searcher,                </li>
     * <li>  undo the bindings, and            </li>
     * <li>  remove the binders.               </li>
     * </ul>
     *
     * @param searcher the current <code>Searcher</code>
     */
    void bind(Searcher searcher);
}