package de.renew.engine.searcher;

/**
 * Helper class for clipping binding badness values below a maximum.
 */
public class BindingBadness {

    /**
     * Constructor for BindingBadness.
     */
    public BindingBadness() {}

    /**
     * The maximum binding badness.
     * <p>
     * Binding badness:
     *  10000  I cannot contribute any information.
     *   9999  I have lots of possibilities to check.
     * 2-9998  I know there are at most so many possibilities
     *      1  I can contribute information without the need
     *         to branch.
     *      0  Sorry, but I know we'll never succeed.
     * </p>
     */
    public static final int MAX = 10000;

    /**
     * Checks if {@code bad} is smaller than 10000 and returns it, otherwise 9999.
     *
     * @param bad the badness that needs to be bound
     * @return {@code bad} if {@code bad} is smaller than 10000, otherwise 9999
     */
    public static int clip(int bad) {
        return (bad < MAX) ? bad : (MAX - 1);
    }
}