package de.renew.engine.searcher;

import java.util.Collection;

/**
 * Interface for targets of channels.
 */
public interface ChannelTarget {

    /**
     * Returns a {@link Collection} of {@link UplinkProvider}s for a given channel.
     *
     * @param channel the channel, whose {@link UplinkProvider}s are returned
     * @return a {@link Collection} of {@link UplinkProvider}s for a given channel
     */
    Collection<UplinkProvider> getUplinkProviders(String channel);
}