package de.renew.engine.searcher;

import de.renew.simulatorontology.simulation.StepIdentifier;
import de.renew.unify.Impossible;


/**
 * Classes should never implement this interface directly, but rather
 * EarlyExecutable or LateExecutable.
 * <p>
 * No other interface except EarlyExecutable and LateExecutable
 * may extend this interface. If another type of executables is
 * added, care must be taken to update the execute method
 * of the simulator helper.
 * See also :{@link EarlyExecutable}
 * and {@link LateExecutable}
 */
public interface Executable {

    /**
     * Get the phase during which this executable should execute.
     * <p>
     * The early executables will be executed before all
     * late executables regardless of the phase. Among
     * early executables and late executables the phase
     * is the determining factor.
     *
     * @return the phase during which this executable should execute
     */
    int phase();

    /**
     * Execute this executable.
     *
     * @param stepIdentifier the executable to be executed
     * @throws Impossible if the step identifier cannot be created
     */
    void execute(StepIdentifier stepIdentifier) throws Impossible;
}